<?php
/**
 * Contact Section
 *
 * Flexible content section for 'contact' section.
 *
 * @package DVVA_Theme
 */

$content = get_sub_field('content');
$form = get_sub_field('form');

$company_location = get_field('company_location', 'option');
$phone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$social_media = get_field('social_media_channels', 'options');

?>

<section class="s-contact">
    <div class="contain">
        <div class="row justify-content-between">
            <div class="col-12 col-lg-7">
                <?= $content; ?>

                <div class="row mt-3">
                    <?php if ($company_location) { ?>
                        <div class="col-12 col-sm-6">
                            <h2 class="mb-2">Address</h2>
                            <address>
                                <?php
                                $address = str_replace(', ', '<br>', $company_location['address']);
                                echo $address;
                                ?>
                            </address>
                        </div>
                    <?php } ?>
                    <?php if ($social_media) { ?>
                        <div class="col-12 col-sm-6">
                            <h2 class="mb-2">Social Media</h2>
                            <?php foreach ($social_media as $social) { ?>
                                <p>
                                    <a href="<?= esc_url($social['full_url']); ?>">
                                        <?= $social['network']['label']; ?>
                                    </a>
                                </p>
                            <?php } ?>
                        </div>
                    <?php } ?>
                    <?php if ($phone) { ?>
                        <div class="col-12 col-sm-6">
                            <h2 class="mb-2">Telephone</h2>
                            <a href="tel:<?= esc_attr($phone); ?>"><?= $phone; ?></a>
                        </div>
                    <?php } ?>
                    <?php if ($email) { ?>
                        <div class="col-12 col-sm-6">
                            <h2 class="mb-2">Email</h2>
                            <a href="mailto:<?= sanitize_email($email); ?>"><?= $email; ?></a>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <?php if ($form) { ?>
                <div class="s-contact__enquire col-12 col-lg-4 flow">
                    <h2>Send us a Message</h2>
                    <?= do_shortcode($form); ?>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
