<?php
/**
 * Site Header
 *
 * Includes header bar, navigation
 *
 * @package DVVA_Theme
 */

?>

<header class="l-header ff-title" data-state="closed">
    <div class="l-header__contain contain">
        <a class="l-header__brand" href="<?php echo esc_url(home_url('/')); ?>">
            <?php
            $logo = get_field('company_logo', 'options');
            if ($logo) { ?>
                <img
                    class="l-header__logo"
                    src="<?= $logo['url']; ?>"
                    alt="<?= $logo['alt']; ?>"
                    loading="eager"
                    width="<?= $logo['width']; ?>"
                    height="<?= $logo['height']; ?>" />
            <?php } else {
                bloginfo('name');
            }
            ?>
        </a>

        <nav class="l-header__nav l-nav">

            <button
                id="nav-toggle"
                type="button"
                class="l-nav__toggle b-navToggle"
                data-state="closed"
                aria-controls="primary-nav"
                aria-expanded="false"
                aria-label="Open primary navigation">
                <div class="b-navToggle__burger">
                    <span class="b-navToggle__bar"></span>
                    <span class="b-navToggle__bar"></span>
                    <span class="b-navToggle__bar"></span>
                </div>
            </button>

            <div class="l-nav__wrap" id="primary-nav" data-state="closed">
                <?php if (has_nav_menu('primary')) {
                    wp_nav_menu([
                        'theme_location'    => 'primary',
                        'menu_container'    => 'ul',
                        'menu_class'        => 'l-nav__menu',
                        'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                    ]);
                } ?>

                <div class="l-nav__btns">
                    <a class="l-nav__signup" href="#0">
                        Become a Member
                    </a>

                    <a class="l-nav__login" href="#0" aria-label="Member Login">
                        <span class="l-nav__loginIcon fas fa-user"></span>
                        <span class="l-nav__loginText">Member Login</span>
                    </a>
                </div>
            </div>
        </nav>
    </div>
</header>
