<?php
/**
 * Hero Intro Section
 *
 * Flexible content section for 'hero_intro' section.
 *
 * @todo replace hero image with svg - probably lower filesize and ability to be animated
 * @todo form functionality
 *
 * @package DVVA_Theme
 */

$title = get_sub_field('title');

?>

<section class="s-heroIntro flex-column fs-4 ff-title">
    <div class="s-heroIntro__contain contain">
        <div class="row">
            <div class="col-12 col-lg-7 flow">
                <h1 class="s-heroIntro__title fw-extrabold"><?= $title; ?></h1>

                <form action="" class="s-heroIntro__form flow">
                    <label>
                        I want to
                        <select class="s-heroIntro__select">
                            <option default value="volunteer">Volunteer</option>
                            <option default value="lorem">Lorem</option>
                            <option default value="ipsum">Ipsum</option>
                        </select>
                    </label>

                    <button class="s-heroIntro__getStarted b-button" type="submit" data-style="fill">
                        <span class="b-button__text">Get Started</span>
                        <span class="b-button__icon fal fa-long-arrow-right"></span>
                    </button>
                </form>
            </div>
        </div>
    </div>
    <img class="s-heroIntro__img" src="<?= get_template_directory_uri(); ?>/dist/images/hero-tmp.png" width="1422" height="1079" loading="eager">
</section>
