<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'primary'   => 'Main Menu',
            'secondary' => 'Footer Menu 1',
            'tertiary'  => 'Footer Menu 2'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters()
    {
        // page theme
        add_filter('body_class', [$this, 'pageTheme']);

        // contact form 7
        add_filter('wpcf7_autop_or_not', '__return_false');
        add_filter('wpcf7_load_css', '__return_false');
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers()
    {
        // Empty
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
    }

    /**
     * pageTheme
     *
     * Adds class to body setting the 'theme' colour of the page
     *
     * @return array array of body classes
     */
    public function pageTheme($classes)
    {
        $theme = get_field('theme_colour');
        if ($theme) {
            $classes[] = 'theme-' . $theme;
        }

        return $classes;
    }
}
