<?php
$title = get_sub_field('timeline_title');
$timelineSections = get_sub_field('timeline_sections');
$timelineTitles = [];
if($timelineSections) {
    foreach($timelineSections as $timeline) {
        array_push($timelineTitles, $timeline['title']);
    } ?>
    <div class="custom-flexible-section timeline-section">
        <div class="contain">
            <h2 class="text-center fw-700"><?= $title; ?></h2>
            <div class="timeline-navigation">
                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                    <?php foreach($timelineTitles as $index => $title) {
                        $titleSlug = strtolower($title);
                        $titleSlug = str_replace( ["#", "'", ";", "&", "?", "!", " "], '', $titleSlug); ?>
                        <a class="nav-item nav-link <?= $index == 0 ? 'active' : ""; ?>" id="nav-<?= $titleSlug; ?>-tab" data-toggle="tab" href="#nav-<?= $titleSlug; ?>" role="tab" aria-controls="nav-<?= $titleSlug; ?>" <?php if($index == 0) { ?>aria-selected="true"<?php } ?>><?= $title; ?></a>
                    <?php }  ?>
                </div>
            </div>

            <div class="timelines-output">
                <div class="tab-content" id="nav-tabContent">
                    <?php foreach($timelineSections as $index => $section) {
                        $titleSlug = strtolower($section['title']);
                        $titleSlug = str_replace( ["#", "'", ";", "&", "?", "!", " "], '', $titleSlug);
                        $timeline = $section['timeline']; ?>
                        <div class="tab-pane fade <?= $index == 0 ? 'show active' : ""; ?>" id="nav-<?= $titleSlug; ?>" role="tabpanel" aria-labelledby="nav-<?= $titleSlug ?>-tab">
                             <?php dump($timeline); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>

        </div>
    </div>
<?php } ?>
