<?php
$selectedArticles = get_sub_field('news_articles');
$args = [
    'post_type' => 'post',
    'numberposts' => 10,
    'post_status' => 'publish'
];
$newsArticles = $selectedArticles ?: get_posts($args);
if($newsArticles) {
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $newsTitle = get_sub_field('news_title');
    $featuredID = get_post_thumbnail_id($newsArticles[0]->ID);
    $featuredDate = strtotime($newsArticles[0]->post_date);
    $featuredCategories = get_the_terms($newsArticles[0]->ID, 'category');

    if($featuredID) {
        $imageAlt = get_post_meta($featuredID, '_wp_attachment_image_alt', TRUE);
        $imageDetails = wp_get_attachment_image_src($featuredID, 'featured-news');
        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
        $imageClass = 'featured-image';
    } else {
        $image = $defaultImage;
        $imageClass = 'default-image';
    }
    ?>
    <section class="custom-flexible-section news-section">
        <?php
        $path = get_template_directory() . '/dist/images/DCT-Swoosh.svg';
        $file = file_get_contents($path);
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        echo str_replace(
            '<svg',
            '<svg id="dct-swoosh" role="img" aria-label="DC Thomson Logo Swoosh"',
            $file
        );
        ?>
        <div class="news-output">
            <div class="contain">
                <?php if($newsTitle) { ?><h2 class="fw-700"><?= $newsTitle; ?></h2><?php } ?>
                <div class="row">
                    <div class="col-lg-5">
                        <div class="featured-article">
                            <div class="image-wrapper <?= $imageClass; ?>">
                                <?= $image; ?>
                            </div>
                            <div class="content-wrapper">
                                <h3 class="fw-700"><a href="<?= get_the_permalink($newsArticles[0]->ID); ?>"><?= $newsArticles[0]->post_title; ?></a></h3>
                                <div class="bottom-wrap">
                                    <div class="holder">
                                        <?php if($featuredCategories) { ?>
                                            <div class="featured-categories u-case fw-700">
                                                <ul>
                                                    <?php foreach($featuredCategories as $cat) { ?>
                                                        <li><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        <?php } ?>
                                        <div class="date fw-500"><?= date('F d, Y', $featuredDate); ?></div>
                                    </div>

                                    <div class="cta">
                                        <a href="<?= get_the_permalink($newsArticles[0]->ID); ?>">
                                             <span class="fa-stack">
                                              <i class="fas fa-circle fa-stack-2x"></i>
                                              <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="offset-lg-1 col-lg-6">

                        <div class="news-feature-section">
                            <?php $newsFeatureType = get_sub_field('news_feature_type'); ?>
                            <?php if($newsFeatureType == 'image') {
                                $newsImage = get_sub_field('news_feature_image');
                                ?>
                                <div class="featured-image">
                                    <div class="featured-wrapper">
                                        <?php
                                        $path = get_template_directory() . '/dist/images/DCT-Blocks.svg';
                                        $file = file_get_contents($path);
                                        $file = str_replace(
                                            '<?xml version="1.0" encoding="UTF-8"?>',
                                            '',
                                            $file
                                        );
                                        echo str_replace(
                                            '<svg',
                                            '<svg id="dct-blocks" role="img" aria-label="DC Thomson Logo Swoosh"',
                                            $file
                                        );
                                        ?>
                                        <img src="<?= $newsImage['url']; ?>" alt="<?= $newsImage['alt']; ?>">
                                    </div>
                                </div>
                            <?php } else {
                                $newsVideo = get_sub_field('news_feature_video');
                                ?>
                                <div class="featured-video">
                                    <div class="featured-wrapper">
                                        <?php
                                        $path = get_template_directory() . '/dist/images/DCT-Blocks.svg';
                                        $file = file_get_contents($path);
                                        $file = str_replace(
                                            '<?xml version="1.0" encoding="UTF-8"?>',
                                            '',
                                            $file
                                        );
                                        echo str_replace(
                                            '<svg',
                                            '<svg id="dct-blocks" role="img" aria-label="DC Thomson Logo Swoosh"',
                                            $file
                                        );
                                        ?>
                                        <video loading="lazy" autoplay muted loop playsinline>
                                            <source src="<?= $newsVideo['url']; ?>" type="video/mp4">
                                        </video>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>


                    </div>
                </div>

                <div class="swiper-container news-swiper">
                    <div class="swiper-wrapper">
                        <?php foreach(array_slice($newsArticles, 1) as $article) {
                            $newsCategories = get_the_terms($article->ID, 'category');
                            $newsThumbnailID = get_post_thumbnail_id($article->ID);
                            $newsDate = strtotime($article->post_date);

                            if($newsThumbnailID) {
                                $imageAlt = get_post_meta($newsThumbnailID, '_wp_attachment_image_alt', TRUE);
                                $imageDetails = wp_get_attachment_image_src($newsThumbnailID, 'news-carousel');
                                $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                                $imageClass = 'featured-image';
                            } else {
                                $image = $defaultImage;
                                $imageClass = 'default-image';
                            }

                            ?>
                            <div class="swiper-slide">

                                <div class="inner-slide">
                                    <div class="image-wrapper <?= $imageClass; ?>">
                                        <?= $image; ?>
                                    </div>
                                    <div class="content-wrapper">
                                        <h3 class="fw-700"><a href="<?= get_the_permalink($article->ID); ?>"><?= $article->post_title; ?></a></h3>
                                        <div class="bottom-wrap">
                                            <div class="holder">
                                                <?php if($newsCategories) { ?>
                                                    <div class="featured-categories u-case fw-700">
                                                        <ul>
                                                            <?php foreach($newsCategories as $cat) { ?>
                                                                <li><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                                                            <?php } ?>
                                                        </ul>
                                                    </div>
                                                <?php } ?>
                                                <div class="date fw-500"><?= date('F d, Y', $newsDate); ?></div>
                                            </div>

                                            <div class="cta">
                                                <a href="<?= get_the_permalink($article->ID); ?>">
                                                     <span class="fa-stack">
                                                      <i class="fas fa-circle fa-stack-2x"></i>
                                                      <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="nav-holder">
            <div class="contain">
                <div class="custom-news-prev"><span class="far fa-chevron-left"></span></div>
                <div class="custom-news-next"><span class="far fa-chevron-right"></span></div>
                <div class="view-all-news fw-700 u-case"><a href="<?= get_permalink( get_option( 'page_for_posts' ) ); ?>">View all news</a></div>
            </div>
        </div>

    </section>
<?php } ?>
