<?php
$slides = get_sub_field('hero_slides');

if($slides) {
    $slideCount = count($slides) == 1 ? 'one-slide' : 'multi-slide';
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    ?>
    <section class="custom-flexible-section hero-section <?= $slideCount; ?>">
        <div class="contain">
            <div class="swiper-container hero-swiper">
                <div class="swiper-wrapper">
                    <?php foreach($slides as $index => $slide) {
                        $slideThumbID = $slide['image'];
                        if($slideThumbID) {
                            $imageAlt = get_post_meta($slide['image']['id'], '_wp_attachment_image_alt', TRUE);
                            $imageDetails = wp_get_attachment_image_src($slide['image']['id'], 'hero-image');
                            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }
                        $toggleEffect = $slide['toggle_svg_effect'];
                        ?>
                        <div class="swiper-slide">
                            <div class="slide-inner">
                                <div class="row">
                                    <div class="col-lg-6 col-xxl-5">
                                        <div class="image-wrapper <?= $imageClass; ?>">
                                            <?php
                                            if($toggleEffect) {
                                                $path = get_template_directory() . '/dist/images/DCT-Blocks.svg';
                                                $file = file_get_contents($path);
                                                $file = str_replace(
                                                    '<?xml version="1.0" encoding="UTF-8"?>',
                                                    '',
                                                    $file
                                                );
                                                echo str_replace(
                                                    '<svg',
                                                    '<svg id="dct-blocks" role="img" aria-label="DC Thomson Logo Swoosh"',
                                                    $file
                                                );
                                            }
                                            ?>
                                            <?= $image; ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 d-flex align-items-center">
                                        <div class="content-wrapper">
                                            <?php if($index == 0) { ?>
                                                <h1 class="fw-700"><?= $slide['title']; ?></h1>
                                            <?php } else {  ?>
                                                <h2 class="fw-700"><?= $slide['title']; ?></h2>
                                            <?php }  ?>
                                            <div class="description"><?= $slide['description']; ?></div>
                                            <?php if($slide['cta']) { ?><div class="cta u-case fw-700"><a href="<?= $slide['cta']['url']; ?>"><?= $slide['cta']['title']; ?></a></div><?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="control-holder">
            <div class="wrapper">
                <?php if(count($slides) > 1) { ?>
                    <div class="custom-prev"><span class="far fa-chevron-left"></span></div>
                    <div class="custom-next"><span class="far fa-chevron-right"></span></div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>
