<?php
$args = [
    'post_type' => 'business',
    'post_status' => 'publish',
    'posts_per_page' => -1
];

$businesses = new WP_Query($args);
if($businesses->have_posts()) {
    $sectionTitle = get_sub_field('title');

    $primaryAssetType = get_sub_field('primary_asset_type');
    $primaryImage = get_sub_field('primary_image');
    $primaryVideo = get_sub_field('primary_video');

    $secondaryAssetType = get_sub_field('secondary_asset_type');
    $secondaryImage = get_sub_field('secondary_image');
    $secondaryVideo = get_sub_field('secondary_video');

    $description = get_sub_field('description');
    $cta = get_sub_field('cta');
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

    if($primaryImage){
        $primaryImageDetails = wp_get_attachment_image_src($primaryImage['id'], 'primary-business-image');
        $primaryImage = '<img src=" ' . $primaryImageDetails[0] . '" alt="'. $primaryImage['alt'] .'">';
        $primaryImageClass = 'featured-image';
    } else {
        $primaryImage = $defaultImage;
        $primaryImageClass = 'default-image';
    }

    if($secondaryImage){
        $secondaryImageDetails = wp_get_attachment_image_src($secondaryImage['id'], 'primary-business-image');
        $secondaryImage = '<img src=" ' . $secondaryImageDetails[0] . '" alt="'. $secondaryImage['alt'] .'">';
        $secondaryImageClass = 'featured-image';
    } else {
        $secondaryImage = $defaultImage;
        $secondaryImageClass = 'default-image';
    }
    ?>
    <section class="custom-flexible-section business-showcase-section">
        <div class="contain">
            <div class="business-output">
                <div class="image-holder">
                    <div class="primary-holder <?= $primaryImageClass; ?>">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                        <?php if($primaryAssetType == 'video' && $primaryVideo) { ?>
                            <video loading="lazy" autoplay muted loop playsinline>
                                <source src="<?= $primaryVideo['url']; ?>" type="video/mp4">
                            </video>
                        <?php } else { ?>
                            <?= $primaryImage; ?>
                        <?php } ?>
                    </div>
                    <div class="secondary-holder <?= $secondaryImageClass; ?>">
                        <?php if($secondaryAssetType == 'video' && $secondaryVideo) { ?>
                            <video loading="lazy" autoplay muted loop playsinline>
                                <source src="<?= $secondaryVideo['url']; ?>" type="video/mp4">
                            </video>
                        <?php } else { ?>
                            <?= $secondaryImage; ?>
                        <?php } ?>
                    </div>
                </div>

                <div class="swiper-holder">
                    <h2 class="fw-700"><?= $sectionTitle; ?></h2>
                    <div class="swiper-container business-swiper">
                        <div class="swiper-wrapper">
                            <?php while($businesses->have_posts()) {
                                $businesses->the_post(); ?>
                                <div class="swiper-slide">
                                    <div class="inner-slide">
                                        <img src="<?= get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                                    </div>
                                </div>
                            <?php } wp_reset_postdata(); ?>
                        </div>

                        <div class="business-showcase-prev"><span class="far fa-chevron-left"></span></div>
                        <div class="business-showcase-next"><span class="far fa-chevron-right"></span></div>
                        <div class="swiper-scrollbar"></div>
                    </div>

                    <?php if($description) { ?>
                        <div class="description">
                            <div class="inner">
                                <?= $description; ?>
                            </div>
                        </div>
                    <?php } ?>

                    <?php if($cta) { ?>
                        <div class="cta fw-700 u-case">
                            <a href="<?= $cta['url']; ?>">
                                <?= $cta['title']; ?>
                                <span class="fa-stack">
                                  <i class="fas fa-circle fa-stack-2x"></i>
                                  <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                </span>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
