<?php
$quote = get_sub_field('quote_selection');
if($quote) {
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $quoteThumbnailID = get_post_thumbnail_id($quote->ID);
    $secondaryImage = get_sub_field('secondary_quote_image');

    if ($quoteThumbnailID) {
        $imageAlt = get_post_meta($quoteThumbnailID, '_wp_attachment_image_alt', TRUE);
        $imageDetails = wp_get_attachment_image_src($quoteThumbnailID, 'primary-quote-image');
        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
        $imageClass = 'featured-image';
    } else {
        $image = $defaultImage;
        $imageClass = 'default-image';
    }

    if ($secondaryImage) {
        $secondaryImageAlt = get_post_meta($secondaryImage['id'], '_wp_attachment_image_alt', TRUE);
        $secondaryImageDetails = wp_get_attachment_image_src($secondaryImage['id'], 'secondary-quote-image');
        $secondaryImage = '<img src="' . $secondaryImageDetails[0] . '" alt="' . $secondaryImageAlt . '" loading="lazy"/>';
        $secondaryImageClass = 'featured-image';
    } else {
        $secondaryImage = $defaultImage;
        $secondaryImageClass = 'default-image';
    }

    ?>
    <section class="custom-flexible-section quote-section">
        <?php
        $path = get_template_directory() . '/dist/images/DCT-Swoosh.svg';
        $file = file_get_contents($path);
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        echo str_replace(
            '<svg',
            '<svg id="dct-swoosh" role="img" aria-label="DC Thomson Logo Swoosh"',
            $file
        );
        ?>
        <div class="contain">
            <div class="quote-wrapper">
                <div class="image-holder">
                    <div class="primary-holder">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                        <div class="quote-holder quote-image <?= $imageClass; ?>"><?= $image; ?></div>
                    </div>
                    <div class="secondary-holder">
                        <div class="quote-holder secondary-image <?= $secondaryImageClass ?>"><?= $secondaryImage; ?></div>
                    </div>
                </div>
                <div class="quote-info fw-700">
                    <div class="quote-by u-case"><?= $quote->post_title; ?></div>
                    <div class="quote-content"><span>"</span><?= $quote->post_content; ?><span>"</span></div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
