<?php
$selectedArticles = get_sub_field('news_articles');
if($selectedArticles) {
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $newsTitle = get_sub_field('title');
    $id = get_sub_field('section_id');
    ?>
    <section class="custom-flexible-section news-section news-video-carousel-section" id="<?= $id; ?>">
        <div class="news-output">
            <div class="contain">
                <?php if($newsTitle) { ?><h2 class="fw-700"><?= $newsTitle; ?></h2><?php } ?>
                <div class="swiper-container news-swiper">
                    <div class="swiper-wrapper">
                        <?php foreach($selectedArticles as $article) {
                            $newsCategories = get_the_terms($article->ID, 'category');
                            $newsThumbnailID = get_post_thumbnail_id($article->ID);
                            $newsDate = strtotime($article->post_date);
                            $image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-carousel');
                            ?>
                            <div class="swiper-slide">

                                <div class="inner-slide">
                                    <div class="image-wrapper <?= $image['class']; ?>">
                                        <a href="<?= get_the_permalink($article->ID); ?>">
                                            <?= $image['output']; ?>
                                        </a>
                                    </div>
                                    <div class="content-wrapper">
                                        <h3 class="fw-700"><a href="<?= get_the_permalink($article->ID); ?>"><?= $article->post_title; ?></a></h3>
                                        <div class="bottom-wrap">
                                            <div class="holder">
                                                <?php if($newsCategories) { ?>
                                                    <div class="featured-categories u-case fw-700">
                                                        <ul>
                                                            <?php foreach($newsCategories as $cat) { ?>
                                                                <li><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                                                            <?php } ?>
                                                        </ul>
                                                    </div>
                                                <?php } ?>
                                                <div class="date fw-500"><?= date('F d, Y', $newsDate); ?></div>
                                            </div>

                                            <div class="cta">
                                                <a href="<?= get_the_permalink($article->ID); ?>">
                                                     <span class="fa-stack">
                                                      <i class="fas fa-circle fa-stack-2x"></i>
                                                      <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="nav-holder">
            <div class="contain">
                <div class="custom-news-prev"><span class="far fa-chevron-left"></span></div>
                <div class="custom-news-next"><span class="far fa-chevron-right"></span></div>
                <div class="view-all-news fw-700 u-case"><a href="/category/video/">View all videos</a></div>
            </div>
        </div>
    </section>
<?php } ?>
