<?php
$newsCategories = get_the_terms(get_the_id(), 'category');
$newsThumbnailID = get_post_thumbnail_id();
$newsDate = strtotime(get_the_date());
$image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-carousel');
?>
<div class="news-col col-md-6 col-lg-4 col-xxl-3">
    <div class="news-inner">
        <div class="image-wrapper <?= $image['class']; ?>">
            <a href="<?php the_permalink(); ?>">
                <?= $image['output']; ?>
            </a>
        </div>
        <div class="content-wrapper">
            <h3 class="fw-700"><a href="<?= get_the_permalink(); ?>"><?php the_title() ?></a></h3>
            <div class="bottom-wrap">
                <div class="holder">
                    <?php if($newsCategories) { ?>
                        <div class="featured-categories u-case fw-700">
                            <ul>
                                <?php foreach($newsCategories as $cat) { ?>
                                    <li><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <div class="date fw-500"><?= date('F d, Y', $newsDate); ?></div>
                </div>

                <div class="cta">
                    <a href="<?= get_the_permalink(); ?>">
                         <span class="fa-stack">
                          <i class="fas fa-circle fa-stack-2x"></i>
                          <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
