<?php
$map = get_field('company_location', 'option');
$formShortcode = get_field('form_shortcode');
$primaryAddress = get_field('address_1');
$secondaryAddress = get_field('address_2');
$primaryPhone = get_field('phone_number_1');
$secondaryPhone = get_field('phone_number_2');
?>
<main class="custom-contact">
    <div class="map-holder">
        <div id="map" data-lat="<?= $map['lat']; ?>" data-lng="<?= $map['lng']; ?>"></div>
        <div class="contain">
            <div class="info-block">
                <h1><?php the_title(); ?></h1>
                <div class="row">
                    <div class="col-lg-6 form-col">
                        <?= do_shortcode($formShortcode); ?>
                    </div>
                    <div class="col-lg-6 address-col">
                        <div class="row">
                            <?php if($primaryAddress) { ?>
                                <div class="col-lg-6 address-item">
                                    <div class="address"><?= $primaryAddress; ?></div>
                                    <?php if($primaryPhone) { ?><div class="phone">T: <a href="tel:<?= $primaryPhone; ?>"><?= $primaryPhone; ?></a></div><?php } ?>
                                </div>
                            <?php } ?>
                            <?php if($secondaryAddress) { ?>
                                <div class="col-lg-6 address-item">
                                    <div class="address"><?= $secondaryAddress; ?></div>
                                    <?php if($secondaryPhone) { ?><div class="phone">T: <a href="tel:<?= $secondaryPhone; ?>"><?= $secondaryPhone; ?></a></div><?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
