<?php
$slides = get_sub_field('slider');
if($slides) {
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $sectionTitle = get_sub_field('section_title');
    ?>
    <section class="custom-flexible-section numbered-slider-section">
        <div class="contain">
            <?php if($sectionTitle) { ?><h2 class="fw-700 text-center"><?= $sectionTitle; ?></h2><?php } ?>
            <div class="swiper-container numbered-slider-swiper">
                <div class="swiper-wrapper">
                    <?php foreach($slides as $slide) {
                        if($slide['image']['id']) {
                            $imageAlt = get_post_meta($slide['image']['id'], '_wp_attachment_image_alt', TRUE);
                            $imageDetails = wp_get_attachment_image_src($slide['image']['id'], '');
                            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }

                        ?>
                        <div class="swiper-slide">
                            <div class="inner-slide">
                                <div class="row no-gutters row-eq-height h-100">
                                    <div class="col-lg-7">
                                        <div class="image-wrapper <?= $imageClass; ?>">
                                            <?= $image; ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        <div class="content-wrapper">
                                            <h3 class="fw-700 u-case"><?= $slide['title']; ?></h3>
                                            <div class="fw-700 desc"><?= $slide['description']; ?></div>
                                            <?php if($slide['call_to_action']) { ?>
                                                <div class="cta fw-700 u-case"><a href="<?= $slide['call_to_action']['url']; ?>"><?= $slide['call_to_action']['title']; ?></a></div>
                                            <?php } ?>
                                            <div class="numbered-slider-pagination"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
