<?php

$args = [
    'post_type' => 'business',
    'post_status' => 'publish',
    'posts_per_page' => -1
];

$businesses = new WP_Query($args);
if($businesses->have_posts()) {
    $sectionTitle = get_sub_field('title'); ?>
    <section class="custom-flexible-section business-showcase-section">
        <div class="contain">
            <h2 class="fw-700"><?= $sectionTitle; ?></h2>

            <div class="business-output">
                <div class="swiper-container business-swiper">
                    <div class="swiper-wrapper">
                        <?php while($businesses->have_posts()) {
                            $businesses->the_post(); ?>
                            <div class="swiper-slide">
                                <div class="inner-slide">
                                    <img src="<?= get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                                </div>
                            </div>
                        <?php } wp_reset_postdata(); ?>
                    </div>

                    <div class="business-showcase-prev"><span class="far fa-chevron-left"></span></div>
                    <div class="business-showcase-next"><span class="far fa-chevron-right"></span></div>

                    <div class="swiper-scrollbar"></div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
