<?php
$socials = get_field('social_media_channels', 'option');
if(!is_page_template('template-login.php')) { ?>
    <footer class="site-footer">
        <div class="contain">
            <div class="row">
                <div class="col-sm-6 col-md-4 col-lg-3 footer-menu-col">
                    <h2>DC Thomson</h2>
                    <?php
                    if (has_nav_menu( 'dc_thomson_footer_menu' )) {
                        wp_nav_menu(['theme_location' => 'dc_thomson_footer_menu', 'menu_class' => '']);
                    }
                    ?>
                </div>
                <div class="col-sm-6 col-md-4 col-lg-3 footer-menu-col">
                    <h2>Quick Links</h2>
                    <?php
                    if (has_nav_menu( 'quick_links_footer_menu' )) {
                        wp_nav_menu(['theme_location' => 'quick_links_footer_menu', 'menu_class' => '']);
                    }
                    ?>
                </div>
                <div class="col-sm-6 col-md-4 col-lg-3 footer-menu-col legal-menu">
                    <h2>Legal</h2>
                    <?php
                    if (has_nav_menu( 'legal_footer_menu' )) {
                        wp_nav_menu(['theme_location' => 'legal_footer_menu', 'menu_class' => '']);
                    }
                    ?>
                </div>
                <div class="col-sm-6 col-md-12 col-lg-3 footer-social-col">
                    <?php if ($socials) { ?>
                        <ul>
                            <?php foreach($socials as $social) {?>
                                <li>
                                    <a href="<?php $social['full_url']; ?>" target="_blank" rel="noopener">
                                    <span class="fa-stack">
                                      <i class="fas fa-circle fa-stack-2x"></i>
                                      <i class="fab <?= $social['platform']; ?> fa-stack-1x fa-inverse"></i>
                                    </span>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>
            <div class="row bottom-row">
                <div class="col-sm-6 copyright-col">
                    <?= '&copy; ' . get_field('copyright_text', 'option') . " " . date("Y"); ?>
                </div>
                <div class="col-sm-6 website-by-col">
                    <p>Website by <?= do_shortcode( '[blue2_logo type="light"]' ); ?></p>
                </div>
            </div>
        </div>
    </footer>
<?php } ?>
