<?php
$videoType = get_sub_field('video_type');
$title = get_sub_field('title');
$id = get_sub_field('section_id');
?>
<section class="custom-flexible-section video-section" id="<?= $id; ?>">

    <?php if($title) { ?><h2 class="fw-700 text-center"><?= $title; ?></h2><?php } ?>

    <div class="video-wrapper">
        <?php if($videoType == 'embed') {
            $iframe = get_sub_field('video_embed');
            preg_match('/src="(.+?)"/', $iframe, $matches);
            $src = $matches[1];
            $params = array(
                'controls'  => 1,
                'hd'        => 1,
                'autohide'  => 1
            );
            $new_src = add_query_arg($params, $src);
            $iframe = str_replace($src, $new_src, $iframe);
            $attributes = 'frameborder="0"';
            $iframe = str_replace('></iframe>', ' ' . $attributes . '></iframe>', $iframe);
            echo $iframe;
        } else {
            $video = get_sub_field('video_file'); ?>
            <video loading="lazy" muted controls>
                <source src="<?= $video['url']; ?>" type="video/mp4">
            </video>
        <?php } ?>
    </div>
</section>
