<?php
$people = get_sub_field('people');
if($people) {
    $title = get_sub_field('title');
    $description = get_sub_field('description');
    $id = get_sub_field('section_id');
    ?>
    <section class="custom-flexible-section people-section" id="<?= $id; ?>">
        <div class="contain">
            <div class="row">
                <div class="col-lg-5 col-xl-4 people-section__info-wrapper">
                    <div class="info-wrapper">
                        <h2 class="fw-700"><?= $title; ?></h2>
                        <?php if($description) { ?>
                            <div class="description"><?= $description; ?></div>
                        <?php } ?>
                        <div class="wrapper">
                            <div class="people-prev"><span class="far fa-chevron-left"></span></div>
                            <div class="people-next"><span class="far fa-chevron-right"></span></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 offset-xl-1 col-xl-7">
                    <div class="swiper-container people-swiper">
                        <div class="swiper-wrapper">
                            <?php foreach($people as $person) {
                                $image = \Blue2\Scruffy\Site::acfImage($person['image']['id'], 'people-carousel-image');
                                ?>
                                <div class="swiper-slide">
                                    <div class="inner-slide">
                                        <div class="image-wrapper <?= $image['class']; ?>">
                                            <?= $image['output']; ?>
                                        </div>
                                        <div class="content-wrapper text-center">
                                            <h3 class="fw-700 u-case"><?= $person['name']; ?></h3>
                                            <?php if($person['position']) { ?><h4><?= $person['position']; ?></h4><?php } ?>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
