<?php
$description = get_field('sub_business_description');
$cta = get_field('sub_business_cta');
$subBusinesses = get_field('sub_business_section');
$postThumbnail = get_the_post_thumbnail_url();
?>

<div class="sub-businesses">
    <div class="contain">

        <?php if($postThumbnail) { ?>
            <img src="<?= $postThumbnail; ?>" alt="<?php the_title(); ?>" class="sub-image">
        <?php } else { ?>
            <h1 class="fw-700 text-center"><?php the_title(); ?></h1>
        <?php } ?>

        <?php if($description) { ?>
            <div class="sub-description">
                <?= $description; ?>
            </div>
        <?php } ?>
        <?php if($cta) { ?>
            <div class="sub-cta fw-700">
                <a href="<?= $cta['url']; ?>" target="<?= $cta['target']; ?>"><?= $cta['title']; ?></a>
            </div>
        <?php } ?>

        <?php if($subBusinesses) { ?>
            <div class="sub-business-container">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <?php
                    $businessCount = 0;
                    foreach($subBusinesses as $business) { $businessCount++; ?>
                        <li class="nav-item u-case">
                            <a class="nav-link <?= $businessCount == 1 ? 'active' : ""; ?>" id="<?= 'tab-' . $businessCount; ?>" data-toggle="tab" href="<?= '#tab' . $businessCount; ?>" role="tab" aria-controls="home" aria-selected="<?= $businessCount == 1 ? true : false; ?>"><?= $business['title']; ?></a>
                        </li>
                    <?php } ?>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <?php
                    $businessSecondaryCount = 0;
                    foreach($subBusinesses as $business) {
                        $businessSecondaryCount++;
                        $businessItems = $business['sub_businesses'];
                        $ctas = $business['ctas'];
                        ?>
                        <div class="tab-pane fade <?= $businessSecondaryCount == 1 ? 'show active' : ""; ?>" id="<?= 'tab' . $businessSecondaryCount; ?>" role="tabpanel" aria-labelledby="<?= 'tab-' . $businessSecondaryCount; ?>">
                            <?php if($ctas) { ?>
                                <ul class="tab-ctas">
                                    <?php foreach($ctas as $cta) { ?>
                                        <li><a href="<?= $cta['cta']['url']; ?>" target="<?= $cta['cta']['target']; ?>"><?= $cta['cta']['title']; ?></a></li>
                                    <?php } ?>
                                </ul>
                            <?php } ?>

                            <div class="inner-grid">
                                <?php if($businessItems) {
                                    foreach ($businessItems as $businessItem) {  //todo - correct thumbnail size ?>
                                        <div class="grid-item">
                                            <a href="" data-toggle="modal" data-target="#businessModal" data-description="<?= $businessItem['description']; ?>" data-title="<?= $businessItem['title']; ?>" data-cta="<?= $businessItem['cta']['url']; ?>">
                                                <img src="<?= $businessItem['image']['url']; ?>" alt="<?php $businessItem['title']; ?>">
                                            </a>
                                        </div>
                                    <?php }
                                } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    </div>

    <div class="modal fade" id="businessModal" tabindex="-1" role="dialog" aria-labelledby="businessModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="button-wrapper">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><span class="far fa-times"></span></span>
                        </button>
                    </div>
                    <div class="content-section text-center">
                        <div class="title u-case fw-700"></div>
                        <div class="description fw-700"></div>
                        <div class="cta"><a href="" target="_blank">Website Link</a></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
