<?php
$primaryImage = get_field('primary_image_top');
$secondaryImage = get_field('secondary_image_top');
$primaryImage = \Blue2\Scruffy\Site::acfImage($primaryImage['id'], 'primary-business-image');
$secondaryImage = \Blue2\Scruffy\Site::acfImage($secondaryImage['id'], 'secondary-business-image');
$primaryContent = get_field('primary_content_section');
$title = get_field('title') ?: get_the_title();
$card = get_field('card');

$primaryImageBottom = get_field('primary_image_bottom');
$secondaryImageBottom = get_field('secondary_image_bottom');
$secondaryContent = get_field('secondary_content_section');
$primaryImageBottom = \Blue2\Scruffy\Site::acfImage($primaryImageBottom['id'], 'business-secondary-image-1');
$secondaryImageBottom = \Blue2\Scruffy\Site::acfImage($secondaryImageBottom['id'], 'business-secondary-image-2');
$websiteCTA = get_field('website_cta');
?>
<section class="custom-flexible-section business-showcase-section">
    <div class="contain">
        <div class="business-output">
            <div class="image-holder">
                <div class="primary-holder <?= $primaryImage['class']; ?>">
                    <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                    <?= $primaryImage['output']; ?>
                </div>
                <div class="secondary-holder <?= $secondaryImage['class']; ?>">
                    <?= $secondaryImage['output']; ?>
                </div>
            </div>
            <div class="content-holder">
                <h1><?= $title; ?></h1>
                <?php the_field('primary_content_section'); ?>
                <?php if($card){
                    ?>
                    <div class="business-card">
                    <?=$card;?>
                    <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                    </div>
                    <?php
                }
                ?>
                <?php if(!$secondaryContent && $websiteCTA) { ?>
                    <div class="cta u-case fw-700">
                        <a href="<?= $websiteCTA; ?>" target="_blank">Visit the site</a>
                    </div>
                <?php } ?>

                <?php if($secondaryContent) { ?>
                    <div class="read-more"><a href="#secondary-section">Read More</a></div>
                <?php } ?>
                
            </div>
        </div>
    </div>
</section>

<?php
if($secondaryContent) { ?>
    <div class="secondary-content-section" id="secondary-section">
        <?php
        $path = get_template_directory() . '/dist/images/DCT-Swoosh.svg';
        $file = file_get_contents($path);
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        echo str_replace(
            '<svg',
            '<svg id="dct-swoosh" role="img" aria-label="DC Thomson Logo Swoosh"',
            $file
        );
        ?>
        <div class="contain">
            <div class="content-holder">
                <?= $secondaryContent; ?>
                <?php if($websiteCTA) { ?>
                    <div class="cta u-case fw-700">
                        <a href="<?= $websiteCTA; ?>" target="_blank">Visit the site</a>
                    </div>
                <?php } ?>
            </div>
            <div class="image-holder">
                <div class="primary-holder <?= $primaryImageBottom['class']; ?>">
                    <?= $primaryImageBottom['output']; ?>
                </div>
                <div class="secondary-holder <?= $secondaryImageBottom['class']; ?>">
                    <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                    <?= $secondaryImageBottom['output']; ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
