<?php
$activateSubBusinesses = get_field('activate_sub_businesses');

?>

<div class="custom-single-business <?= $activateSubBusinesses ? 'subs-active' : 'subs-inactive'; ?>">
    <?php
    if($activateSubBusinesses) {
        get_template_part('templates/business/single-layouts/sub-businesses');
    } else {
        get_template_part('templates/business/single-layouts/no-sub-businesses');
    }
    ?>
</div>

<?php $args = [
    'post_type' => 'business',
    'numberposts' => 4,
    'post_status' => 'publish',
    'orderby' => 'rand',
    'order' => 'DESC',
    'exclude' => [get_the_id()]
];
$relatedBusinesses = get_posts($args); ?>

<?php if($relatedBusinesses) { ?>
    <div class="related-businesses">
        <div class="contain">
            <h2 class="fw-700">View Other Businesses</h2>
            <div class="row row-eq-height">
                <?php foreach($relatedBusinesses as $article) {
                    $businessThumbnailID = get_post_thumbnail_id($article->ID);
                    $image = \Blue2\Scruffy\Site::acfImage($businessThumbnailID, 'other-business-image'); ?>
                    <div class="col-sm-6 col-lg-3 business-col">
                        <div class="inner-slide">
                            <div class="image-wrapper <?= $image['class']; ?>">
                                <a href="<?= get_the_permalink($article->ID); ?>">
                                    <?= $image['output']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="cta fw-700 u-case"><a href="/businesses/">View All</a></div>
        </div>
    </div>
<?php } ?>
