<?php
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$featuredNewsArticle = get_field('featured_news_article', 'option');
$featuredVideoArticle = get_field('featured_video_article', 'option');
$queriedObject = get_queried_object();
$categoryOutput = is_category() ? ' - ' . $queriedObject->name : "";

?>
<div class="custom-news-archive">

    <?php
    $path = get_template_directory() . '/dist/images/DCT-Swoosh.svg';
    $file = file_get_contents($path);
    $file = str_replace(
        '<?xml version="1.0" encoding="UTF-8"?>',
        '',
        $file
    );
    echo str_replace(
        '<svg',
        '<svg id="dct-swoosh" role="img" aria-label="DC Thomson Logo Swoosh" aria-hidden="true"',
        $file
    );
    ?>

    <div class="contain">
        <?php if(($paged == 1 && !is_home()) || ($paged > 1) || (!$featuredNewsArticle && !$featuredVideoArticle)) { ?><h1 class="fw-700"><?= 'News' . $categoryOutput; ?></h1><?php } ?>
        <?php if($featuredNewsArticle && $paged == 1 && is_home()) { ?>
            <div class="featured-news-articles">
                <div class="row d-flex justify-content-center justify-content-xl-start">
                    <?php
                    if($featuredNewsArticle) {
                        foreach ($featuredNewsArticle as $article) {
                            $newsCategories = get_the_terms($article->ID, 'category');
                            $newsThumbnailID = get_post_thumbnail_id($article->ID);
                            $newsDate = strtotime($article->post_date);
                            $image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-archive-featured-image');
                            ?>
                            <div class="news-col col-md-6">
                                <h2>Featured News</h2>
                                <div class="news-inner">
                                    <div class="image-wrapper <?= $image['class']; ?>">
                                        <a href="<?= get_the_permalink($article->ID); ?>">
                                            <?= $image['output']; ?>
                                        </a>
                                    </div>
                                    <div class="content-wrapper">
                                        <h3 class="fw-700"><a
                                                    href="<?= get_the_permalink($article->ID); ?>"><?= get_the_title($article->ID) ?></a>
                                        </h3>
                                        <div class="info-wrap"><?= get_the_excerpt($article->ID); ?></div>
                                        <div class="bottom-wrap">
                                            <div class="holder">
                                                <?php if ($newsCategories) { ?>
                                                    <div class="featured-categories u-case fw-700">
                                                        <ul>
                                                            <?php foreach ($newsCategories as $cat) { ?>
                                                                <li>
                                                                    <a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a>
                                                                </li>
                                                            <?php } ?>
                                                        </ul>
                                                    </div>
                                                <?php } ?>
                                                <div class="date fw-500"><?= date('F d, Y', $newsDate); ?></div>
                                            </div>

                                            <div class="cta">
                                                <a href="<?= get_the_permalink(); ?>">
                                             <span class="fa-stack">
                                              <i class="fas fa-circle fa-stack-2x"></i>
                                              <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                            </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php }
                        wp_reset_postdata();
                    }
                    ?>
                    <?php
                    if($featuredVideoArticle) {
                        foreach ($featuredVideoArticle as $article) {
                            $newsCategories = get_the_terms($article->ID, 'category');
                            $newsThumbnailID = get_post_thumbnail_id($article->ID);
                            $newsDate = strtotime($article->post_date);
                            $image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-archive-featured-image');
                            ?>
                            <div class="news-col col-md-6">
                                <h2>Featured Video</h2>
                                <div class="news-inner">
                                    <div class="image-wrapper <?= $image['class']; ?>">
                                        <a href="<?= get_the_permalink($article->ID); ?>">
                                            <?= $image['output']; ?>
                                        </a>
                                    </div>
                                    <div class="content-wrapper">
                                        <h3 class="fw-700"><a
                                                    href="<?= get_the_permalink($article->ID); ?>"><?= get_the_title($article->ID) ?></a>
                                        </h3>
                                        <div class="info-wrap"><?= get_the_excerpt($article->ID); ?></div>
                                        <div class="bottom-wrap">
                                            <div class="holder">
                                                <?php if ($newsCategories) { ?>
                                                    <div class="featured-categories u-case fw-700">
                                                        <ul>
                                                            <?php foreach ($newsCategories as $cat) { ?>
                                                                <li>
                                                                    <a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a>
                                                                </li>
                                                            <?php } ?>
                                                        </ul>
                                                    </div>
                                                <?php } ?>
                                                <div class="date fw-500"><?= date('F d, Y', $newsDate); ?></div>
                                            </div>

                                            <div class="cta">
                                                <a href="<?= get_the_permalink(); ?>">
                                             <span class="fa-stack">
                                              <i class="fas fa-circle fa-stack-2x"></i>
                                              <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                            </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php }
                        wp_reset_postdata();
                    }
                    ?>
                </div>
            </div>
        <?php } ?>

        <div class="standard-new-output">
            <div class="row">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
            <div class="custom-pagination">
                <?php the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('Previous', 'textdomain'),
                    'next_text' => __('Next', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </div>
</div>

<?php if(get_field('flexible_sections', 'option')) { ?>
    <div class="flexible-layout">
        <?php Blue2\Scruffy\Utils::flexibleLoop('flexible_sections', 'option'); ?>
    </div>
<?php } ?>
