<?php
//Template Name: Login
get_header();
$loginBg = get_field('login_background', 'option')
?>
<div class="custom-login-template">
    <div class="holder" style="background-image:url('<?= $loginBg['url']; ?>')">
        <header>
            <?php
            $path = get_template_directory() . '/dist/images/DCT.svg';
            $file = file_get_contents($path);

            // remove xml header
            $file = str_replace(
                '<?xml version="1.0" encoding="UTF-8"?>',
                '',
                $file
            );
            // add class and attributes for accessibility
            echo str_replace(
                '<svg',
                '<svg class="l-header__logo" role="img" aria-label="DC Thomson"',
                $file
            );
            ?>
        </header>
        <main>
            <?= wp_login_form(); ?>
        </main>
        <footer>
            <div class="copyright"><?= '&copy; ' . get_field('copyright_text', 'option') . " " . date("Y"); ?></div>
        </footer>
    </div>
</div>
<?php get_footer(); ?>
