<?php
$args = [
    'post_type' => 'business',
    'post_status' => 'publish',
    'posts_per_page' => -1
];

$businesses = new WP_Query($args);
if($businesses->have_posts()) {
    $sectionTitle = get_sub_field('title'); ?>
    <section class="custom-flexible-section business-showcase-section">
        <div class="contain">

            <?php if($sectionTitle) { ?>
                <h2 class="text-center fw-700"><?= $sectionTitle; ?></h2>
            <?php } ?>

            <div class="business-grid">
                <?php while($businesses->have_posts()) {
                    $businesses->the_post(); ?>
                    <div class="business-item">
                        <a href="<?php the_permalink(); ?>">
                            <div class="inner-slide">
                                <img src="<?= get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                            </div>
                        </a>
                    </div>
                <?php } wp_reset_postdata(); ?>
            </div>

        </div>
    </section>
<?php } ?>
