<?php
$queriedObject = get_queried_object();
$args = [
    'post_type' => 'business',
    'post_status' => 'publish',
    'posts_per_page' => -1
];

$businesses = get_posts($args);
$businessArchiveTitle = get_field('business_archive_title', 'option');
$businessArchiveDescription = get_field('business_archive_description', 'option');
?>
<div class="custom-business-archive">
    <?php
    $primaryImage = get_field('business_archive_feature_image', 'option');
    $primaryImage = \Blue2\Scruffy\Site::acfImage($primaryImage['id'], 'primary-business-image');
    ?>
    <section class="custom-flexible-section business-showcase-section">
        <div class="contain">
            <div class="business-output">
                <div class="image-holder">
                    <div class="primary-holder <?= $primaryImage['class']; ?>">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                        <?= $primaryImage['output']; ?>
                    </div>
                </div>

                <div class="swiper-holder">

                    <?php if($businessArchiveTitle) { ?><h2 class="archive-title fw-700"><?= $businessArchiveTitle ?></h2><?php } ?>
                    <?php if($businessArchiveDescription) { ?><div class="archive-description"><?= $businessArchiveDescription ?></div><?php } ?>

                    <div class="business-archive-grid">
                        <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php if(get_field('business_flexible_sections', 'option')) { ?>
    <div class="flexible-layout">
        <?php Blue2\Scruffy\Utils::flexibleLoop('business_flexible_sections', 'option', 'flexible_sections'); ?>
    </div>
<?php } ?>
