<?php
$queriedObject = get_queried_object();
$args = [
    'post_type' => 'business',
    'post_status' => 'publish',
    'posts_per_page' => -1
];

$businesses = get_posts($args);
?>
<div class="custom-business-archive">
    <?php
    $primaryImage = get_field('business_archive_feature_image', 'option');
    $primaryImage = \Blue2\Scruffy\Site::acfImage($primaryImage['id'], 'primary-business-image');
    ?>
    <section class="custom-flexible-section business-showcase-section">
        <div class="contain">
            <div class="business-output">
                <div class="image-holder">
                    <div class="primary-holder <?= $primaryImage['class']; ?>">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                        <?= $primaryImage['output']; ?>
                    </div>
                </div>

                <div class="swiper-holder">
                    <div class="swiper-container business-swiper">
                        <div class="swiper-wrapper">
                            <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
                        </div>
                        <div class="business-showcase-prev"><span class="far fa-chevron-left"></span></div>
                        <div class="business-showcase-next"><span class="far fa-chevron-right"></span></div>
                        <div class="swiper-scrollbar"></div>
                    </div>
                    <div class="swiper-container business-swiper-secondary">
                        <div class="swiper-wrapper">
                            <?php foreach($businesses as $business) { ?>
                                <div class="swiper-slide">
                                    <h3 class="fw-700"><?php the_field('archive_title', $business->ID); ?></h3>
                                    <div class="archive-description"><?php the_field('archive_description', $business->ID); ?></div>
                                    <div class="more-about u-case fw-500"><a href="<?= get_the_permalink($business->ID); ?>">More about <?= $business->post_title; ?></a></div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php if(get_field('business_flexible_sections', 'option')) { ?>
    <div class="flexible-layout">
        <?php Blue2\Scruffy\Utils::flexibleLoop('business_flexible_sections', 'option', 'flexible_sections'); ?>
    </div>
<?php } ?>
