<?php
$selectedArticles = get_sub_field('news_articles');
$args = [
    'post_type' => 'post',
    'numberposts' => 10,
    'post_status' => 'publish'
];
$newsArticles = $selectedArticles ?: get_posts($args);
if($newsArticles) {
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $newsTitle = get_sub_field('news_title');
    $newsImage = get_sub_field('news_article_image');

    $featuredID = get_post_thumbnail_id($newsArticles[0]->ID);
    $featuredDate = strtotime($newsArticles[0]->post_date);
    $featuredCategories = get_the_terms($newsArticles[0]->ID, 'category');

    if($featuredID) {
        $imageAlt = get_post_meta($featuredID, '_wp_attachment_image_alt', TRUE);
        $imageDetails = wp_get_attachment_image_src($featuredID, '');
        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
        $imageClass = 'featured-image';
    } else {
        $image = $defaultImage;
        $imageClass = 'default-image';
    }
    ?>
    <section class="custom-flexible-section news-section">
        <div class="contain">
            <div class="news-output">



                <div class="row">
                    <div class="col-lg-5">
                        <?php if($newsTitle) { ?><h2 class="fw-700"><?= $newsTitle; ?></h2><?php } ?>
                        <div class="featured-article">
                            <div class="image-wrapper <?= $imageClass; ?>">
                                <?= $image; ?>
                            </div>
                            <div class="content-wrapper">
                                <h3 class="fw-700"><?= $newsArticles[0]->post_title; ?></h3>

                                <div class="bottom-wrap">
                                    <div class="holder">
                                        <?php if($featuredCategories) { ?>
                                            <div class="featured-categories u-case fw-700">
                                                <ul>
                                                    <?php foreach($featuredCategories as $cat) { ?>
                                                        <li><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        <?php } ?>
                                        <div class="date fw-500"><?= date('F d, Y', $featuredDate); ?></div>
                                    </div>

                                    <div class="cta">
                                        <a href="<?= get_the_permalink($newsArticles[0]->ID); ?>">
                                     <span class="fa-stack">
                                      <i class="fas fa-circle fa-stack-2x"></i>
                                      <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                    </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="offset-lg-1 col-lg-6">
                        <div class="featured-image">
                            <div class="image-wrapper featured-image">
                                <img src="<?= $newsImage['url']; ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
