<?php
$slides = get_sub_field('hero_slides');
if($slides) {
    $slideCounter = 0;
    ?>
    <section class="custom-flexible-section hero-section">
        <div class="contain">
            <div class="swiper-container hero-swiper">
                <div class="swiper-wrapper">
                    <?php foreach($slides as $index => $slide) { ?>
                        <div class="swiper-slide">
                            <div class="slide-inner">
                                <div class="row">
                                    <div class="col-lg-6 col-xxl-5">
                                        <div class="image-wrapper">
                                            <img src="<?= $slide['image']['url']; ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 d-flex align-items-center">
                                        <div class="content-wrapper">
                                            <?php if($index == 0) { ?>
                                                <h1 class="fw-700"><?= $slide['title']; ?></h1>
                                            <?php } else {  ?>
                                                <h2 class="fw-700"><?= $slide['title']; ?></h2>
                                            <?php }  ?>
                                            <div class="description"><?= $slide['description']; ?></div>
                                            <?php if($slide['cta']) { ?><div class="cta u-case fw-700"><a href="<?= $slide['cta']['url']; ?>"><?= $slide['cta']['title']; ?></a></div><?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="control-holder">
            <div class="wrapper">
                <div class="custom-prev"><span class="far fa-chevron-left"></span></div>
                <div class="custom-next"><span class="far fa-chevron-right"></span></div>
            </div>
        </div>
    </section>
<?php } ?>
