<?php
$title = get_sub_field('title');
$description = get_sub_field('description');
$featuredBoardImage = \Blue2\Scruffy\Site::acfImage(get_sub_field('featured_board_image')['id'], 'featured-quote-image');
$featuredBoardQuote = get_sub_field('featured_board_quote');
$featuredBoardQuoteName = get_sub_field('featured_board_quote_name');
$boardMembers = get_sub_field('board_members');
$bgImage = get_sub_field('background_image');
?>
<div class="custom-flexible-section board-section">
    <div class="primary-section">
        <div class="contain">
            <h2 class="fw-700"><?= $title; ?></h2>
            <div class="row">
                <div class="col-lg-6">
                    <?php if($description) { ?>
                        <div class="description"><?= $description; ?></div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="featured-section" style="background-image:url('<?= $bgImage['url']; ?>')">
        <div class="contain">
            <div class="row">
                <div class="offset-lg-6 col-lg-6">
                    <div class="featured-quote-wrapper">
                        <div class="image-wrapper <?= $featuredBoardImage['class']; ?>">
                            <?= $featuredBoardImage['output']; ?>
                        </div>
                        <div class="content-wrapper">
                            <?php if($featuredBoardQuote) { ?><div class="quote">"<?= $featuredBoardQuote; ?>"</div><?php } ?>
                            <?php if($featuredBoardQuoteName) { ?><div class="name u-case"><?= $featuredBoardQuoteName; ?></div><?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="board-members">
        <div class="contain">
            <div class="row d-flex justify-content-center">
                <?php foreach($boardMembers as $boardMember) {
                    $boardMemberImage = \Blue2\Scruffy\Site::acfImage($boardMember['image']['id'], 'board-image'); ?>
                    <div class="col-sm-6 col-lg-4 board-col">
                        <a href="" data-toggle="modal" data-target="#peopleModal" data-description="<?= $boardMember['description']; ?>" data-name="<?= $boardMember['name']; ?>" data-position="<?= $boardMember['position']; ?>">
                            <div class="image-wrapper <?= $boardMemberImage['class']; ?>">
                                <?= $boardMemberImage['output']; ?>
                            </div>
                            <div class="content-wrapper text-center">
                                <h3 class="fw-700 u-case"><?= $boardMember['name']; ?></h3>
                                <?php if($boardMember['position']) { ?><h4><?= $boardMember['position']; ?></h4><?php } ?>
                            </div>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>

    <div class="modal fade" id="peopleModal" tabindex="-1" role="dialog" aria-labelledby="peopleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="button-wrapper">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><span class="far fa-times"></span></span>
                        </button>
                    </div>
                    <div class="content-section text-center">
                        <div class="title u-case fw-700"></div>
                        <div class="position"></div>
                        <div class="description fw-700"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>
