<?php
$investorCategories = get_terms(['taxonomy' => 'investor-information-type', 'hide_empty' => true]);
$queriedObject = get_queried_object();

if(is_tax()) {
    $categoryDescription = category_description($queriedObject->ID);
} else{
    $categoryDescription = get_field('investor_information_description', 'option');
}
?>
<div class="custom-investor-information-archive">
    <div class="contain">
        <div class="row">
            <div class="col-lg-4">
                <div class="investor-categories">
                    <ul>
                        <?php foreach($investorCategories as $cat) {  ?>
                            <li class="u-case fw-700"><a href="<?= get_category_link($cat->term_id); ?>" class="<?= $queriedObject->slug == $cat->slug ? 'active' : ""; ?>"><?= $cat->name; ?></a></li>
                        <?php }  ?>
                    </ul>
                    <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="archive-output">
                    <div class="top-section">
                        <h1><a href="/investor-information/">Investor Information</a> <?php if(is_tax()) { ?><span>/ <?= $queriedObject->name; ?></span><?php } ?></h1>
                        <?php if($categoryDescription) { ?>
                            <div class="category-description">
                                <?= $categoryDescription; ?>
                            </div>
                        <?php } ?>
                    </div>


                    <div class="row">
                        <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
