<?php
$title = get_sub_field('timeline_title');
$timelineSections = get_sub_field('timeline_sections');
$timelineTitles = [];
if($timelineSections) {
    foreach($timelineSections as $timeline) {
        array_push($timelineTitles, $timeline['title']);
    } ?>
    <div class="custom-flexible-section timeline-section">
        <div class="contain">
            <h2 class="text-center fw-700"><?= $title; ?></h2>
            <div class="timeline-navigation">
                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                    <?php foreach($timelineTitles as $index => $title) {
                        $titleSlug = strtolower($title);
                        $titleSlug = str_replace( ["#", "'", ";", "&", "?", "!", " "], '', $titleSlug); ?>
                        <a class="nav-item nav-link u-case fw-700 <?= $index == 0 ? 'active' : ""; ?>" id="nav-<?= $titleSlug; ?>-tab" data-toggle="tab" href="#nav-<?= $titleSlug; ?>" role="tab" aria-controls="nav-<?= $titleSlug; ?>" <?php if($index == 0) { ?>aria-selected="true"<?php } ?>><?= $title; ?></a>
                    <?php }  ?>
                </div>
            </div>
            <div class="timelines-output">
                <div class="tab-content" id="nav-tabContent">
                    <?php foreach($timelineSections as $index => $section) {
                        $titleSlug = strtolower($section['title']);
                        $titleSlug = str_replace( ["#", "'", ";", "&", "?", "!", " "], '', $titleSlug);
                        $timeline = $section['timeline']; ?>
                        <div class="tab-pane fade <?= $index == 0 ? 'show active' : ""; ?>" id="nav-<?= $titleSlug; ?>" role="tabpanel" aria-labelledby="nav-<?= $titleSlug ?>-tab">

                            <div class="timeline-control timeline-prev"><span class="far fa-chevron-left"></span></div>
                            <div class="timeline-control timeline-next"><span class="far fa-chevron-right"></span></div>

                            <?php if($section['timeline']) {
                                $timelineYears = []; ?>
                                <div class="swiper-container timeline-swiper">
                                    <div class="swiper-wrapper">
                                        <?php foreach($section['timeline'] as $timeline) {
                                            array_push($timelineYears, $timeline['year']);
                                            // todo - add coorect image size
                                            $image = \Blue2\Scruffy\Site::acfImage($timeline['image']['id'], 'primary-business-image'); ?>
                                            <div class="swiper-slide">
                                                <div class="timeline-slide">
                                                    <div class="image <?= $image['class']; ?>"><?= $image['output']; ?></div>
                                                    <div class="year fw-700"><div class="inner"><?= $timeline['year']; ?></div></div>
                                                    <div class="content"><?= $timeline['description']; ?></div>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            <?php } ?>
                            <div class="timeline-jumps" data-years=<?= json_encode($timelineYears); ?>>
                                <div class="swiper-container year-jumps">
                                    <div class="swiper-wrapper">

                                    </div>
                                </div>
                                <div class="year-nav year-prev">
                                     <span class="fa-stack">
                                      <i class="fas fa-circle fa-stack-2x"></i>
                                      <i class="far fa-chevron-left fa-stack-1x fa-inverse"></i>
                                    </span>
                                </div>
                                <div class="year-nav year-next">
                                    <span class="fa-stack">
                                      <i class="fas fa-circle fa-stack-2x"></i>
                                      <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
