<?php
$args = [
    'post_type' => 'business',
    'numberposts' => 4,
    'post_status' => 'publish',
    'orderby' => 'rand',
    'order' => 'DESC',
    'exclude' => [get_the_id()]
];
$relatedBusinesses = get_posts($args);

$primaryImage = get_field('primary_image_top');
$secondaryImage = get_field('secondary_image_top');
$primaryImage = \Blue2\Scruffy\Site::acfImage($primaryImage['id'], 'primary-business-image');
$secondaryImage = \Blue2\Scruffy\Site::acfImage($secondaryImage['id'], 'secondary-business-image');
$primaryContent = get_field('primary_content_section');
$title = get_field('title') ?: get_the_title();

$primaryImageBottom = get_field('primary_image_bottom');
$secondaryImageBottom = get_field('secondary_image_bottom');
$secondaryContent = get_field('secondary_content_section');
$primaryImageBottom = \Blue2\Scruffy\Site::acfImage($primaryImageBottom['id'], 'primary-business-image');
$secondaryImageBottom = \Blue2\Scruffy\Site::acfImage($secondaryImageBottom['id'], 'secondary-business-image');
$websiteCTA = get_field('website_cta');

?>

<div class="custom-single-business">
    <section class="custom-flexible-section business-showcase-section">
        <div class="contain">
            <div class="business-output">
                <div class="image-holder">
                    <div class="primary-holder <?= $primaryImage['class']; ?>">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                        <?= $primaryImage['output']; ?>
                    </div>
                    <div class="secondary-holder <?= $secondaryImage['class']; ?>">
                        <?= $secondaryImage['output']; ?>
                    </div>
                </div>
                <div class="content-holder">
                    <h1><?= $title; ?></h1>
                    <?php the_field('primary_content_section'); ?>
                    <?php if(!$secondaryContent && $websiteCTA) { ?>
                        <div class="cta u-case fw-700">
                            <a href="<?= $websiteCTA; ?>" target="_blank">Visit the site</a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>

    <?php
    if($secondaryContent) { ?>
        <div class="secondary-content-section">
            <?php
            $path = get_template_directory() . '/dist/images/DCT-Swoosh.svg';
            $file = file_get_contents($path);
            $file = str_replace(
                '<?xml version="1.0" encoding="UTF-8"?>',
                '',
                $file
            );
            echo str_replace(
                '<svg',
                '<svg id="dct-swoosh" role="img" aria-label="DC Thomson Logo Swoosh"',
                $file
            );
            ?>
            <div class="contain">
                <div class="content-holder">
                    <?= $secondaryContent; ?>
                    <?php if($websiteCTA) { ?>
                        <div class="cta u-case fw-700">
                            <a href="<?= $websiteCTA; ?>" target="_blank">Visit the site</a>
                        </div>
                    <?php } ?>
                </div>
                <div class="image-holder">
                    <div class="primary-holder <?= $primaryImageBottom['class']; ?>">
                        <?= $primaryImageBottom['output']; ?>
                    </div>
                    <div class="secondary-holder <?= $secondaryImageBottom['class']; ?>">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                        <?= $secondaryImageBottom['output']; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>

</div>

<?php if($relatedBusinesses) { ?>
    <div class="related-businesses">
        <div class="contain">
            <h2 class="fw-700">View Other Businesses</h2>
            <div class="row row-eq-height">
                <?php foreach($relatedBusinesses as $article) {
                    $businessThumbnailID = get_post_thumbnail_id($article->ID);
                    $image = \Blue2\Scruffy\Site::acfImage($businessThumbnailID, 'other-business-image'); ?>
                    <div class="col-sm-6 col-lg-3 business-col">
                        <div class="inner-slide">
                            <div class="image-wrapper <?= $image['class']; ?>">
                                <a href="<?= get_the_permalink($article->ID); ?>">
                                    <?= $image['output']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="cta fw-700 u-case"><a href="/businesses/">View All</a></div>
        </div>
    </div>
<?php } ?>
