import { fontawesome, throttle } from './utils';
import Swiper from 'swiper';

const nav = {
    breakpoint: 992,
    isOpen: false,
    lastWidth: window.innerWidth,
    el: {
        scrollEl:   document.documentElement,
        toggle:     document.querySelector('.l-nav__toggle'),
        nav:        document.querySelector('.l-nav'),
        header:     document.querySelector('.l-header'),
        submenus:   document.querySelectorAll('.l-nav__menu .sub-menu')
    },
    init: () => {
        nav.el.toggle.addEventListener('click', nav.toggle);
        window.addEventListener('resize', nav.resize);

        if (nav.el.submenus) {
            nav.el.submenus.forEach((el, i) => {
                const parent = el.parentElement;
                const link = parent.firstChild;

                parent.addEventListener('mouseover', () => nav.submenuOpen(parent, link, i));
                parent.addEventListener('mouseout', () => nav.submenuClose(parent, link, i));
            });
        }
    },

    toggle: () => {
        const isOpen = nav.el.toggle.getAttribute('data-state') === 'open';
        if (isOpen) {
            nav.close();
        } else {
            nav.open();
        }
    },

    open: () => {
        nav.el.scrollEl.style.overflow = 'hidden';

        nav.el.header.setAttribute('data-state', 'open');

        nav.el.nav.setAttribute('data-state', 'open');

        nav.el.toggle.setAttribute('data-state', 'open');
        nav.el.toggle.setAttribute('aria-expanded', 'true');
        nav.el.toggle.setAttribute('aria-label', 'Close primary navigation');

        nav.el.nav.focus();

        nav.isOpen = true;
    },

    close: () => {
        nav.el.scrollEl.style.overflow = null;

        nav.el.header.setAttribute('data-state', 'closed');

        nav.el.nav.setAttribute('data-state', 'closed');

        nav.el.toggle.setAttribute('data-state', 'closed');
        nav.el.toggle.setAttribute('aria-expanded', 'false');
        nav.el.toggle.setAttribute('aria-label', 'Open primary navigation');

        nav.el.toggle.focus();

        nav.isOpen = false;
    },

    resize: throttle(() => {
        const currentWidth = window.innerWidth;

        // going from below breakpoint to above
        if (nav.lastWidth <= nav.breakpoint && currentWidth > nav.breakpoint) {
            // if nav open, close it
            if (nav.isOpen) {
                nav.close();
            }

            // add submenu aria
            nav.submenuAria(true);
        }

        // going from above breakpoint to below
        if (nav.lastWidth > nav.breakpoint && currentWidth <= nav.breakpoint) {
            // remove submenu aria
            nav.submenuAria(false);
        }

        nav.lastWidth = currentWidth;
    }, 1000)
};

const common = () => {
    nav.init();
    fontawesome();

    if ($('.hero-swiper').length) {
        if ($('.hero-swiper .swiper-slide').length === 1) {
            $('.swiper-wrapper').addClass('disabled');
        }

        new Swiper('.hero-swiper', {
            watchOverflow: true,
            loop: true,
            spaceBetween: 42,
            slidesPerView: 1,
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
            navigation: {
                nextEl: '.custom-next',
                prevEl: '.custom-prev',
            },
        });
    }

    if ($('.news-swiper').length) {
        new Swiper('.news-swiper', {
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 25
                },
                768: {
                    slidesPerView: 2,
                    spaceBetween: 25
                },
                992: {
                    slidesPerView: 3,
                    spaceBetween: 25
                },
                1200: {
                    slidesPerView: 3,
                    spaceBetween: 55
                },
                1500: {
                    spaceBetween: 55,
                    slidesPerView: 4,
                }
            },
            navigation: {
                nextEl: '.custom-news-next',
                prevEl: '.custom-news-prev',
            },
        });
    }

    if ($('.numbered-slider-swiper').length) {
        new Swiper('.numbered-slider-swiper', {
            pagination: {
                el: '.numbered-slider-pagination',
                clickable: true,
                renderBullet(index, className) {
                    return `<span class='${className}'>${index + 1}</span>`;
                },
            },
            spaceBetween: 50,
            slidesPerView: 1,
        });
    }

    if ($('.business-swiper-secondary').length && $('.post-type-archive-business').length) {
        const secondarySwiper = new Swiper('.business-swiper-secondary', {
            watchSlidesVisibility: true,
            watchSlidesProgress: true,
            loop: true,
            slidesPerView: 1,
            allowTouchMove: false,
        });
        const primarySwiper = new Swiper('.business-swiper', {
            effect: 'coverflow',
            loop: true,
            grabCursor: true,
            centeredSlides: true,
            slidesPerView: 1.5,
            coverflowEffect: {
                rotate: 50,
                stretch: 0,
                depth: 300,
                modifier: 1.5,
                slideShadows: false,
            },
            scrollbar: {
                draggable: true,
                el: '.swiper-scrollbar',
                hide: false,
            },
            navigation: {
                nextEl: '.business-showcase-next',
                prevEl: '.business-showcase-prev',
            },
            thumbs: {
                swiper: secondarySwiper,
            },
        });
    }

    if ($('.business-swiper').length && !$('.post-type-archive-business').length) {
        new Swiper('.business-swiper', {
            effect: 'coverflow',
            loop: true,
            grabCursor: true,
            centeredSlides: true,
            slidesPerView: 1.5,
            coverflowEffect: {
                rotate: 50,
                stretch: 0,
                depth: 300,
                modifier: 1.5,
                slideShadows: false,
            },
            scrollbar: {
                draggable: true,
                el: '.swiper-scrollbar',
                hide: false,
            },
            navigation: {
                nextEl: '.business-showcase-next',
                prevEl: '.business-showcase-prev',
            },
        });
    }

    if ($('.people-swiper').length) {
        new Swiper('.people-swiper', {
            breakpoints: {
                0: {
                    slidesPerView: 1.25,
                    spaceBetween: 32
                },
                700: {
                    slidesPerView: 2.1,
                    spaceBetween: 32,
                }
            },
            navigation: {
                nextEl: '.people-next',
                prevEl: '.people-prev',
            },
        });
    }

    let timelineSwiper;
    let yearSwiper;

    function initTimelineSlides() {
        timelineSwiper = new Swiper('.tab-pane.active .timeline-swiper', {
            observer: true,
            observeParents: true,
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 55
                },
                720: {
                    slidesPerView: 2,
                    spaceBetween: 55
                },
                1200: {
                    slidesPerView: 3,
                    spaceBetween: 55
                },
            },
            navigation: {
                nextEl: '.timeline-next',
                prevEl: '.timeline-prev',
            },
        });
    }


    function initYearSlides() {
        yearSwiper = new Swiper('.tab-pane.active .year-jumps', {
            observer: true,
            observeParents: true,
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 10
                },
                720: {
                    slidesPerView: 2,
                    spaceBetween: 10
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 10
                },
                1200: {
                    slidesPerView: 4,
                    spaceBetween: 10
                },
                1500: {
                    slidesPerView: 5,
                    spaceBetween: 10
                },
            },
            navigation: {
                nextEl: '.year-next',
                prevEl: '.year-prev',
            },
        });
    }

    function yearSplicer() {
        initYearSlides();
        const yearBlocks = [];
        const timelineJumps = $('.tab-pane.active .timeline-jumps');
        const windowWidth = $(window).width();
        const blockOutput = [];
        const years = JSON.parse(timelineJumps.attr('data-years'));

        if (windowWidth <= 720) {
            console.log(years);
            $.each(years, function(index, value) {
                blockOutput.push(`<div class="swiper-slide"><div class="timeline-jump" data-start-year="${value}">${value}</div></div>`);
            });
        } else {
            let blockSize = 3;
            if (windowWidth <= 1200) {
                blockSize = 2;
            }
            while (years.length > 0) {
                yearBlocks.push(years.splice(0, blockSize));
            }
            //Get First and last items in loop
            $.each(yearBlocks, function(index, value) {
                if (value.length < 2) {
                    return value;
                }
                blockOutput.push(`<div class="swiper-slide"><div class="timeline-jump" data-start-year="${value[0]}">${value[0]} - ${value[value.length - 1]}</div></div>`);
            });
        }
        yearSwiper.removeAllSlides();
        yearSwiper.appendSlide(blockOutput);
    }

    if ($('.timeline-swiper').length) {
        initTimelineSlides();
        yearSplicer();
    }

    $('.timeline-navigation .nav-tabs a').on('shown.bs.tab', function() {
        timelineSwiper.destroy(true);
        timelineSwiper = null;

        yearSwiper.destroy(true);
        yearSwiper = null;

        initTimelineSlides();
        yearSplicer();
    });

    if ($('.timeline-swiper').length) {
        $(window).on('resize', function() {
            yearSplicer();
        });
    }

    $('body').on('click', '.timeline-jump', function() {
        const startYear = $(this).data('start-year');
        $('.tab-pane.active .timeline-swiper .timeline-slide').each(function(index, item) {
            const yearSelector = $(item).find('.year')
                .text();

            if (parseInt(yearSelector, 10) === startYear) {
                timelineSwiper.slideTo(index);
            }
        });
    });

    $('#peopleModal').on('show.bs.modal', function(event) {
        const item = $(event.relatedTarget);
        const name = item.data('name');
        const position = item.data('position');
        const description = item.data('description');
        const email = item.data('email');

        const modal = $(this);
        modal.find('.title').text(name);
        modal.find('.position').text(position);
        modal.find('.description').text(description);

        if (email) {
            $('.email-link').show();
            modal.find('.email-link').attr('href', `mailto:${email}`);
        } else {
            $('.email-link').hide();
        }
    });

    let resizeTimer = 0;
    function calcLines() {
        $('.node-wrapper svg').remove();
        $('div[class^="dot"]').each(function(i, j) {
            const thisDiv = $(j).position();
            const nextDiv = $('div[class^="dot"]').eq(i + 1)
                .position();
            const thisDot = $(j).find('.node-circle')
                .position();
            const nextDot = $('div[class^="dot"]').eq(i + 1)
                .find('.node-circle')
                .position();

            if (typeof nextDiv !== 'undefined') {
                const x1 = thisDiv.left + Math.abs(thisDot.left) + 17;
                const y1 = thisDiv.top + Math.abs(thisDot.top / 2) - 12;
                const x2 = nextDiv.left + Math.abs(nextDot.left) + 17;
                const y2 = nextDiv.top + Math.abs(nextDot.top / 2) - 12;
                const newLine = `<svg class="info-section-line" height="100%" width="100%"><line stroke-dasharray="5,5" d="M5 20 l215 0" x1="${x1}" y1="${y1}" x2="${x2}" y2="${y2}" stroke="#51BCE5" stroke-width="2"/></svg>`;
                $('.node-wrapper').append(newLine);
            }
        });
    }

    $(document).ready(function() {
        $(window).trigger('resize');
    });

    $(window).on('resize', function() {
        clearTimeout(resizeTimer);
        resizeTimer = setTimeout(function() {
            calcLines();
        }, 250);
    });
};

export default common;
