<?php
namespace Blue2\Scruffy\Controllers;

class InvestorInformationController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('pre_get_posts', [$this, 'investorArchiveAdjustments']);
    }

    private function registerFilters()
    {
    }

    public function registerTaxonomies()
    {
        $type = new \Blue2\Common\Taxonomy("investor-information-type", "Type", "Types", "investor-information", [], $args = [
            'admin_column' => true,
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }


    public function investorArchiveAdjustments( $query )
    {
        if (!is_admin() && $query->is_main_query() && (is_post_type_archive('investor-information') || is_tax('investor-information-type'))) {
            $query->set('posts_per_page', -1);
        }
    }
}
