<?php
namespace Blue2\Scruffy\Controllers;

class CorporateGovernanceController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('pre_get_posts', [$this, 'corporateArchiveAdjustments']);
    }

    private function registerFilters()
    {
    }

    public function registerTaxonomies()
    {
        $type = new \Blue2\Common\Taxonomy("corporate-governance-type", "Type", "Types", "corporate-governance", [], $args = [
            'admin_column' => true,
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }


    public function corporateArchiveAdjustments( $query )
    {
        if (!is_admin() && $query->is_main_query() && (is_post_type_archive('corporate-governance') || is_tax('corporate-governance-type'))) {
            $query->set('posts_per_page', -1);
        }
    }
}
