<?php
$investorCategories = get_terms(['taxonomy' => 'corporate-governance-type', 'hide_empty' => false]);
$queriedObject = get_queried_object();
?>
<div class="custom-investor-information-archive">
    <div class="contain">
        <div class="row">
            <div class="col-lg-4">
                <div class="investor-categories">
                    <ul>
                        <?php foreach($investorCategories as $cat) {  ?>
                            <li class="u-case fw-700"><a href="<?= get_category_link($cat->term_id); ?>" class="<?= $queriedObject->slug == $cat->slug ? 'active' : ""; ?>"><?= $cat->name; ?></a></li>
                        <?php }  ?>
                    </ul>
                    <?= file_get_contents(get_template_directory_uri() . '/dist/images/DCT-Blocks.svg'); ?>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="archive-output">
                    <h1>Corporate Governance <?php if(is_tax()) { ?><span>/ <?= $queriedObject->name; ?></span><?php } ?></h1>
                    <div class="row">
                        <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
