<?php
$slides = get_sub_field('hero_slides');
if($slides) { ?>
    <section class="custom-flexible-section hero-section">
        <div class="contain">
            <div class="swiper-container hero-swiper">
                <div class="swiper-wrapper">
                    <?php foreach($slides as $slide) { ?>
                        <div class="swiper-slide">
                            <div class="slide-inner">
                                <div class="row">
                                    <div class="col-lg-5">
                                        <img src="<?= $slide['image']['url']; ?>">
                                    </div>
                                    <div class="offset-lg-1 col-lg-5">
                                        <!-- todo - add h1 alt -->
                                        <h2 class="fw-700"><?= $slide['title']; ?></h2>
                                        <div class="description"><?= $slide['description']; ?></div>
                                        <div class="cta u-case fw-700"><a href="<?= $slide['cta']['url']; ?>"><?= $slide['cta']['title']; ?></a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="custom-prev"><span class="far fa-chevron-left"></span></div>
        <div class="custom-next"><span class="far fa-chevron-right"></span></div>
    </section>
<?php } ?>
