<?php
$newsCategories = get_the_terms(get_the_id(), 'category');
$newsThumbnailID = get_post_thumbnail_id();
$newsDate = strtotime(get_the_date());
$image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-carousel');
$args = [
    'post_type' => 'post',
    'number_posts' => 10,
    'post_status' => 'publish',
    'exclude' => [get_the_id()]
];
$relatedNews = get_posts($args);
?>

<div class="custom-single-news">
    <div class="contain">
        <div class="row">
            <div class="col-xl-8">
                <div class="title-wrapper">
                    <div class="top-wrapper">
                        <?php if($newsCategories) { ?>
                            <div class="featured-categories u-case fw-700">
                                <ul>
                                    <?php foreach($newsCategories as $cat) { ?>
                                        <li><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        <?php } ?>
                        <div class="date fw-500"><?= date('F d, Y', $newsDate); ?></div>
                    </div>
                    <h1 class="fw-700"><?php the_title(); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <?php if($newsThumbnailID) {
                    $imageAlt = get_post_meta($newsThumbnailID, '_wp_attachment_image_alt', TRUE);
                    $imageDetails = wp_get_attachment_image_src($newsThumbnailID, 'single-news-image');
                    $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>'; ?>
                    <div class="image-wrapper">
                        <?= $image; ?>
                    </div>
                <?php } ?>

                <div class="content-wrapper">
                    <?php the_content(); ?>
                </div>
            </div>
            <aside class="col-lg-4 aside-col">
                <?php
                $newsLinks = get_field('featured_news_links_single', 'option');
                $prev = get_previous_post();
                $next = get_next_post();
                ?>
                <div class="other-articles">
                    <div class="previous-article <?= $next ? 'previous-active' : 'inactive-nav'; ?>"><a href="<?= $next ? get_the_permalink($next->ID) : ""; ?>"><span class="far fa-chevron-left"></span></a></div>
                    <div class="next-article <?= $prev ? 'next-active' : 'inactive-nav'; ?>"><a href="<?= $prev ? get_the_permalink($prev->ID) : ""; ?>"><span class="far fa-chevron-right"></span></a></div>
                    <div class="view-all-news fw-700 u-case"><a href="<?= get_permalink( get_option( 'page_for_posts' ) ); ?>">View all news</a></div>
                </div>

                <?php if($newsLinks) { ?>
                    <ul class="news-links">
                        <?php foreach($newsLinks as $link) { ?>
                            <li class="fw-700"><a href="<?= $link['link']['url']; ?>"><div class="text"><?= $link['link']['title']; ?></div><div class="holder"><span class="far fa-chevron-right"></span></div></a></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </aside>
        </div>
    </div>
</div>

<?php if($relatedNews) {
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $newsTitle = get_sub_field('news_title'); ?>
    <div class="related-news">
        <section class="custom-flexible-section news-section">
            <div class="news-output">
                <div class="contain">
                    <h2 class="fw-700">Our News</h2>
                    <div class="swiper-container news-swiper">
                        <div class="swiper-wrapper">
                            <?php foreach($relatedNews as $article) {
                                $newsCategories = get_the_terms($article->ID, 'category');
                                $newsThumbnailID = get_post_thumbnail_id($article->ID);
                                $newsDate = strtotime($article->post_date);
                                $image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-carousel');
                                ?>
                                <div class="swiper-slide">

                                    <div class="inner-slide">
                                        <div class="image-wrapper <?= $image['class']; ?>">
                                            <a href="<?= get_the_permalink($article->ID); ?>">
                                                <?= $image['output']; ?>
                                            </a>
                                        </div>
                                        <div class="content-wrapper">
                                            <h3 class="fw-700"><a href="<?= get_the_permalink($article->ID); ?>"><?= $article->post_title; ?></a></h3>
                                            <div class="bottom-wrap">
                                                <div class="holder">
                                                    <?php if($newsCategories) { ?>
                                                        <div class="featured-categories u-case fw-700">
                                                            <ul>
                                                                <?php foreach($newsCategories as $cat) { ?>
                                                                    <li><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                                                                <?php } ?>
                                                            </ul>
                                                        </div>
                                                    <?php } ?>
                                                    <div class="date fw-500"><?= date('F d, Y', $newsDate); ?></div>
                                                </div>

                                                <div class="cta">
                                                    <a href="<?= get_the_permalink($article->ID); ?>">
                                                     <span class="fa-stack">
                                                      <i class="fas fa-circle fa-stack-2x"></i>
                                                      <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                                    </span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="nav-holder">
                <div class="contain">
                    <div class="custom-news-prev"><span class="far fa-chevron-left"></span></div>
                    <div class="custom-news-next"><span class="far fa-chevron-right"></span></div>
                    <div class="view-all-news fw-700 u-case"><a href="<?= get_permalink( get_option( 'page_for_posts' ) ); ?>">View all news</a></div>
                </div>
            </div>
        </section>
    </div>
<?php } ?>
