<?php
$people = get_sub_field('people');
if($people) {
    $title = get_sub_field('title');
    $description = get_sub_field('description'); ?>
    <section class="custom-flexible-section people-section">
        <div class="contain">
            <div class="row">
                <div class="col-lg-5 col-xl-4">
                    <div class="info-wrapper">
                        <h2 class="fw-700"><?= $title; ?></h2>
                        <?php if($description) { ?>
                            <div class="description"><?= $description; ?></div>
                        <?php } ?>
                        <div class="wrapper">
                            <div class="people-prev"><span class="far fa-chevron-left"></span></div>
                            <div class="people-next"><span class="far fa-chevron-right"></span></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 offset-xl-1 col-xl-7">
                    <div class="swiper-container people-swiper">
                        <div class="swiper-wrapper">
                            <?php foreach($people as $person) {
                                $image = \Blue2\Scruffy\Site::acfImage($person['image']['id'], '');
                                ?>
                                <div class="swiper-slide">
                                    <div class="inner-slide">
                                        <a href="" data-toggle="modal" data-target="#peopleModal" data-email="<?= $person['email']; ?>" data-description="<?=  $person['description']; ?>" data-name="<?= $person['name']; ?>" data-position="<?= $person['position']; ?>">
                                            <div class="image-wrapper <?= $image['class']; ?>">
                                                <?= $image['output']; ?>
                                            </div>
                                            <div class="content-wrapper text-center">
                                                <h3 class="fw-700 u-case"><?= $person['name']; ?></h3>
                                                <?php if($person['position']) { ?><h4><?= $person['position']; ?></h4><?php } ?>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="peopleModal" tabindex="-1" role="dialog" aria-labelledby="peopleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="button-wrapper">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><span class="far fa-times"></span></span>
                            </button>
                        </div>
                        <div class="content-section text-center">
                            <div class="title u-case fw-700"></div>
                            <div class="position"></div>
                            <div class="description fw-700"></div>
                            <div class="contact u-case fw-700"><a href="" class="email-link">Contact <span class="far fa-envelope"></span></a></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
<?php } ?>
