<?php
namespace Blue2\Scruffy;

class Utils extends \Blue2\Common\Theme\Utils
{
    public static function flexibleLoop($fieldName = "sections", $option = '')
    {
        if (have_rows($fieldName, $option)) {
            while (have_rows($fieldName, $option)) {
                the_row();
                get_template_part('templates/' . $fieldName . '/' . get_row_layout());
            }
        }
    }

    public static function archiveWrapped($headerName = "", $footerName = "")
    {
        if (!get_post_type()) {
            global $wp_query;

            $page_for_posts = get_option( 'page_for_posts' );
            $postsID = $wp_query->queried_object->ID;

            if($page_for_posts == $postsID) {
                $postType = 'post';
            } elseif(is_tax('type')) {
                $postType = 'investor-information';
            } else {
                $postType = $wp_query->query['post_type'];
            }
        } else {
            $postType = get_post_type();
        }

        get_header($headerName);
        locate_template('templates/' . $postType . '/archive.php', true);
        get_footer($footerName);
    }

}
