<?php
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$featuredNewsArticles = get_field('featured_news_articles', 'option');
?>
<div class="custom-news-archive">

    <?php
    $path = get_template_directory() . '/dist/images/DCT-Swoosh.svg';
    $file = file_get_contents($path);
    $file = str_replace(
        '<?xml version="1.0" encoding="UTF-8"?>',
        '',
        $file
    );
    echo str_replace(
        '<svg',
        '<svg id="dct-swoosh" role="img" aria-label="DC Thomson Logo Swoosh"',
        $file
    );
    ?>

    <div class="contain">
        <h1 class="fw-700"><?= $featuredNewsArticles && $paged == 1 ? 'Featured News' : 'News'; ?></h1>
        <?php if($featuredNewsArticles && $paged == 1) { ?>
            <div class="featured-news-articles">
                <div class="row d-flex justify-content-center justify-content-xl-start">
                    <?php foreach($featuredNewsArticles as $article) {
                        $newsCategories = get_the_terms($article->ID, 'category');
                        $newsThumbnailID = get_post_thumbnail_id($article->ID);
                        $newsDate = strtotime($article->post_date);
                        $image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-carousel');
                        ?>
                        <div class="news-col col-md-6 col-xl-4">
                            <div class="news-inner">
                                <div class="image-wrapper <?= $image['class']; ?>">
                                    <a href="<?= get_the_permalink($article->ID); ?>">
                                        <?= $image['output']; ?>
                                    </a>
                                </div>
                                <div class="content-wrapper">
                                    <h3 class="fw-700"><a href="<?= get_the_permalink($article->ID); ?>"><?= get_the_title($article->ID) ?></a></h3>
                                    <div class="info-wrap"><?= get_the_excerpt($article->ID); ?></div>
                                    <div class="bottom-wrap">
                                        <div class="holder">
                                            <?php if($newsCategories) { ?>
                                                <div class="featured-categories u-case fw-700">
                                                    <ul>
                                                        <?php foreach($newsCategories as $cat) { ?>
                                                            <li><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                                                        <?php } ?>
                                                    </ul>
                                                </div>
                                            <?php } ?>
                                            <div class="date fw-500"><?= date('F d, Y', $newsDate); ?></div>
                                        </div>

                                        <div class="cta">
                                            <a href="<?= get_the_permalink(); ?>">
                                             <span class="fa-stack">
                                              <i class="fas fa-circle fa-stack-2x"></i>
                                              <i class="far fa-chevron-right fa-stack-1x fa-inverse"></i>
                                            </span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } wp_reset_postdata(); ?>
                </div>
            </div>
        <?php } ?>

        <div class="standard-new-output">
            <div class="row">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
            <div class="custom-pagination">
                <?php the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('Previous', 'textdomain'),
                    'next_text' => __('Next', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </div>
</div>

<?php if(get_field('flexible_sections', 'option')) { ?>
    <div class="flexible-layout">
        <?php Blue2\Scruffy\Utils::flexibleLoop('flexible_sections', 'option'); ?>
    </div>
<?php } ?>
