<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'dc_thomson_footer_menu' => 'DC Thomson - Footer Menu',
            'quick_links_footer_menu' => 'Quick Links - Footer Menu',
            'legal_footer_menu' => 'Legal - Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers(){
        //Empty
    }

    public function registerPostTypes()
    {
        Post\Business::registerPostType();
        Post\Quote::registerPostType();
    }

    public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/DCT.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="default-image" role="img" aria-label="DC Thomson"',
            $file
        );
    }

    public function customImageSizes()
    {
        add_image_size('hero-image', 632, 632, true);
        add_image_size('primary-business-image', 397, 575, true);
        add_image_size('secondary-business-image', 496, 258, true);
        add_image_size('featured-news', 630, 379, true);
        add_image_size('news-carousel', 323, 194, true);
        add_image_size('primary-quote-image', 603, 651, true);
        add_image_size('secondary-quote-image', 1110, 444, true);
        add_image_size('numbered-carousel', 925, 614, true);
        add_image_size('featured-quote-image', 766, 460, true);
        add_image_size('board-image', 495, 545, true);
        add_image_size('primary-image-section', 952, 571, true);
        add_image_size('secondary-image-section', 476, 476, true);
    }

    public static function acfImage($id, $size, $postID = null) {
        if($id) {
            $imageAlt = get_post_meta($id, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($id, $size);
            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
            $imageClass = 'featured-image';
        } else {
            $image = self::getDefaultImage($postID);
            $imageClass = 'default-image';
        }
        return ['output' => $image, 'class' => $imageClass];
    }

}
