<header class="l-header" data-state="closed">
    <div class="l-header__contain contain">
        <a class="l-header__brand" href="<?php echo esc_url(home_url('/')); ?>">
            <?php
            $path = get_template_directory() . '/dist/images/DCT.svg';
            $file = file_get_contents($path);

            // remove xml header
            $file = str_replace(
                '<?xml version="1.0" encoding="UTF-8"?>',
                '',
                $file
            );

            // add class and attributes for accessibility
            echo str_replace(
                '<svg',
                '<svg class="l-header__logo" role="img" aria-label="DC Thomson"',
                $file
            );
            ?>
        </a>

        <nav class="l-header__nav l-nav">
            <button
                    id="nav-toggle"
                    type="button"
                    class="l-nav__toggle b-navToggle"
                    data-state="closed"
                    aria-controls="primary-nav"
                    aria-expanded="false"
                    aria-label="Open primary navigation">
                <div class="b-navToggle__burger">
                    <span class="b-navToggle__bar"></span>
                    <span class="b-navToggle__bar"></span>
                    <span class="b-navToggle__bar"></span>
                </div>
            </button>


            <div class="holder">
                <div class="l-nav__top-nav">
                    <div class="inner">
                        <ul>
                            <li><a href=""><span class="far fa-search"></span> Search</a></li>
                            <li><a href=""><span class="fas fa-lock"></span> Log out</a></li>
                        </ul>
                    </div>
                </div>

                <div class="l-nav__wrap" id="primary-nav" data-state="closed">

                    <?php if (has_nav_menu('main_menu')) {
                        wp_nav_menu([
                            'theme_location'    => 'main_menu',
                            'menu_container'    => 'ul',
                            'menu_class'        => 'l-nav__menu',
                            'items_wrap'        => '
                            <ul id="%1$s" class="%2$s" role="list">
                                <div class="top-wrap">
                                     <li><a href=""><span class="far fa-search"></span> Search</a></li>
                                        <li><a href=""><span class="fas fa-lock"></span> Log out</a></li>
                                </div>
                                %3$s
                            </ul>
',
                        ]);
                    } ?>
                </div>
            </div>
        </nav>
    </div>
</header>

