<?php

?>
<section class="location-section">
    <div class="row">
        <div class="col-md-3">
            <img class="logo" src="<?= get_template_directory_uri() ?>/dist/images/Simon-Howie-logo.svg"
                 alt="Simon Howie">
        </div>
        <div class="col-md-5 title-section">
            <h1>Click and Collect Dashboard</h1>
            <h2><?= $_GET['location']; ?></h2>
        </div>
        <div class="col-md-4 overview-section">
            <span>Overview:</span>
            <div class="row overview-box">
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-xl-4">
                            <span class="order-count ready"></span>
                            Ready
                        </div>
                        <div class="col-xl-4">
                            <span class="order-count new"></span>
                            New orders
                        </div>
                        <div class="col-xl-4">
                            <span class="order-count to-make"></span>
                            To make up
                        </div>
                    </div>
                </div>
                <div class="col-xl-4">
                    <form action="" method="POST">
                        <input type="hidden" name="orderTypes"
                               value="<?= isset($_POST['orderTypes']) && $_POST['orderTypes'] == 'pastOrders' ? 'currentOrders' : 'pastOrders'; ?>">
                        <input type="submit" class="btn btn-primary"
                               value="<?= isset($_POST['orderTypes']) && $_POST['orderTypes'] == 'pastOrders' ? 'Current Orders' : 'Past Orders'; ?>">
                    </form>
                </div>
            </div>
        </div>
        <?php
        if (isset($_POST['orderTypes'])) {
            $orderTypes = $_POST['orderTypes'];
        } else {
            $orderTypes = 'currentOrders';
        }

        if (isset($_POST['search'])) {
            $orders = B2\OrderController::searchOrders($_POST['search']);
        } else {
            $orders = B2\OrderController::getOrders($orderTypes);
        } ?>

        <script> data = <?= $orders; ?> </script>
        <form class="search-form" action="" method="POST">
            <input type="text" class="search" name="search" placeholder="Search by name or postcode">
            <input type="submit" class="submit" value="Go">
        </form>
        <div id="boxcontainer"></div>
    </div>
</section>