<?php

namespace B2\Order;

class OrderItem
{
    private $orderItemData;
    private $itemKey;
    private $orderId;

    public function __construct($orderItemData, $itemKey, $orderId)
    {
        $this->orderItemData = $orderItemData;
        $this->itemKey = $itemKey;
        $this->orderId = $orderId;
    }

    public function getTotal()
    {
        return $this->orderItemData->get_total();
    }

    public function newOrderItemData()
    {

        $newItemArray = [
            'product_thumbnail' => $this->getThumbnail(),
            'product_title' => $this->getOrderName(),
            'weight' => $this->getOrderItemWeight(),
            'weight_for_one' => $this->getWeightForOne(),
            'unit_label' => $this->getUnitLabel(),
            'unit' => floor($this->getNoOfPeople()),
            'size' => $this->getPackSize(),
            'qty' => $this->getQuantity(),
        ];

        return $newItemArray;
    }

    public function getThumbnail()
    {
        if (get_the_post_thumbnail_url($this->getProductId(), 'thumbnail')) {
            return get_the_post_thumbnail_url($this->getProductId(), 'thumbnail');
        } else {
            return 'https://d1ssu070pg2v9i.cloudfront.net/pex/simonhowie/2019/02/04095001/default-image-950x950-150x150.jpg';
        }
    }

    public function getProductId()
    {
        return $this->orderItemData->get_product_id();
    }

    public function getOrderName()
    {
        return $this->orderItemData->get_name();
    }

    public function getOrderItemWeight()
    {

        if (wc_get_order_item_meta($this->itemKey, 'Required Weight (g)')) {
            return wc_get_order_item_meta($this->itemKey, 'Required Weight (g)');
        } else if (wc_get_order_item_meta($this->itemKey, 'Weight (g)')) {
            return wc_get_order_item_meta($this->itemKey, 'Weight (g)');
        } else {
            return '';
        }
    }

    public function getWeightForOne()
    {
        if (array_key_exists('weight_of_one_unit', $this->getProductMeta())) {
            return $this->getProductMeta()['weight_of_one_unit'][0];
        } else {
            return $this->getProductMeta()['weight_to_feed_one_person'][0];
        }
    }

    public function getProductMeta()
    {
        return get_post_meta($this->getProductId());
    }

    public function getUnitLabel()
    {
        if (array_key_exists('unit_label', $this->getProductMeta())) {
            return $this->getProductMeta()['unit_label'][0];
        } elseif($this->getNoOfPeople() > 0) {
            return 'People';
        } else {
            return 'N/A';
        }
    }

    public function getNoOfPeople()
    {

        if ($this->getWeightForOne() > 0) {
            return ($this->getOrderItemWeight() && $this->getWeightForOne() > 0 ? ($this->getOrderItemWeight() / $this->getWeightForOne()) : '');
        } else if (array_key_exists('unit_label', $this->getProductMeta())) {
            return $this->getProductMeta()['unit_label'][0];
        }
    }

    public function getPackSize()
    {
        $packSize = new OrderPackSize($this->getProduct());
        return ($packSize->getPackSize() ? $packSize->getPackSize() : '');
    }

    public function getProduct()
    {
        return $this->orderItemData->get_product();
    }

    public function getQuantity()
    {
        return $this->orderItemData->get_quantity();
    }

}