<?php

namespace B2\Order;

class Order
{
    private $orderData;

    public function __construct($orderData)
    {
        $this->orderData = $orderData;
    }

    public function getOrderID()
    {
        return $this->orderData->get_id();
    }

    public function getOrderData()
    {
        return $this->orderData->get_data();
    }

    public function getName()
    {
        return $this->getOrderData()['billing']['first_name'] . ' ' . $this->getOrderData()['billing']['last_name'];
    }

    public function getPhoneNumber()
    {
        return $this->getOrderData()['billing']['phone'];
    }
    public function getOrderType()
    {
        return $this->orderData->get_type();
    }

    public function getOrderStatus()
    {
        $orderStatus = new WooOrderStatus($this->orderData);
        return $orderStatus->tidyOrderStatus();
    }

    public function getOrderDate()
    {
        return $this->orderData->get_date_created();
    }

    public function getCustomerNote()
    {
        return $this->orderData->get_customer_note();
    }

    public function getTotal()
    {
        return $this->orderData->get_total();
    }

    public function getOrderItems()
    {
        return $this->orderData->get_items();
    }

    public function getShopNumber()
    {
        $shopNo = new OrderShopNumber($this->getOrderData());
        return $shopNo->getShopOrderNumber();
    }

    public function getFinalPrice()
    {
        $finalPrice = new FinalPrice($this->getOrderData());
        return $finalPrice->getFinalPrice();

    }

    public function newOrderData()
    {
        $newOrderArray = [
            'id' => $this->getOrderID(),
            'order_date' => $this->getOrderDate(),
            'client_name' => $this->getName(),
            'contact_number' => $this->getPhoneNumber(),
            'status' => $this->getOrderStatus(),
            'shop_order_number' => $this->getShopNumber(),
            'final_price' => $this->getFinalPrice(),
            'estimated_price' => $this->getTotal()
        ];

        return $newOrderArray;
    }

}