/** TODO update refresh to only refresh data( not window) **/
let idleTime = 0;
let orderPrintJson = '';

function timerIncrement() {
    idleTime = idleTime + 1;
    console.log(idleTime);
    if (idleTime > 1) { // 1 minutes
        window.location.reload();
    }
}

(function () {
    setInterval(timerIncrement, 60000);
    $(this).mousemove(function (e) {
        idleTime = 0;
    });
    $(this).keypress(function (e) {
        idleTime = 0;
    });
})();

function getUrlParameter(name) {
    name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    var results = regex.exec(location.search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}

function submitNote() {
    if (this.getParentView().validate()) {
        var formValues = $$("notes_form").getValues();
        console.log(formValues);

        webix.ajax().post("/wp-json/click-collect/v1/add-note/", {
            action: "note",
            formValues
        }, function (text, data, xhr) {
            if (data.json() === 'success') {
                webix.message({type: "message-style", text: "Comment added"});
                var note = {note_content: formValues.note};
                $$("notes_table").add(note);
            } else {
                webix.message({type: "message-style", text: "Sorry something went wrong, please try again"});
            }
        });
    }
}

function markNew(value, config){
    if (value === "New Order")
        return { "border":"1px solid #ea7600 !important" };
    return value;
};

(function () {

    let newOrderCount = 0;
    let readyOrderCount = 0;
    let toMakeCount = 0;
    let collectedCount = 0;

    jQuery.each(data, function (i, val) {

        jQuery.each(val.orders, function (i, val) {
            if (val.status === '1') {
                newOrderCount++;
            } else if (val.status === '5') {
                readyOrderCount++;
            } else if (val.status === '6') {
                collectedCount++;
            } else if (val.status !== '5' || val.status !== '6') {
                toMakeCount++;
            }
        });

        $('#boxcontainer').append("<div id='box" + i + "'></div>");


        var order_status = [
            {id: 1, value: "New Order"},
            {id: 2, value: "Awaiting Processing"},
            {id: 3, value: "Started"},
            {id: 4, value: "Being Collated"},
            {id: 5, value: "&#9993; Ready for collection"},
            {id: 6, value: "Collected"},
            {id: 7, value: "Cancelled"},
            {id: 8, value: "Not Collected"},
            {id: 9, value: "Collection Date Changed"},
        ];

        val.orders.conditions = [
            [1, 5, "=", 'Cancelled', "cancelled"],
        ];


        let date = val.date;
        var grid = {
            container: "box" + i,
            borderless: true,
            multi: true,
            rows: [
                {
                    header: '<div class="title">Order Collection Date: <span>' + val.date + '</span></div><div class="display"><strong>Display:</strong> <a>All: <span class="order-count">' + val.orders.length + '</span></a>| <a>Needing made up: </span>0</span></a></div>',
                    headerHeight: 100,
                    collapsed: false,
                    body: {
                        view: "datatable",
                        editable: true,
                        footer: true,
                        responsive: true,
                        id: "box" + i,
                        position: "center",
                        rowHeight: 80,
                        columns: [
                            {width: 25},
                            {
                                id: "id",
                                header: "Web order No.",
                                css: {'font-weight': 'bold'},
                                footer: "<div class='webix_el_button'><a class='print_all' href='/content/plugins/click-collect-plugin/templates/print-all-orders.php?location=" + getUrlParameter('location') + "&date=" + i + "&status=all'>Print all</a></div>",
                                width: 150
                            },
                            {id: "client_name", header: "Client Name", width: 150},
                            {id: "contact_number", header: "Contact Number", width: 150},
                            {
                                id: "status",
                                css: "select_column",
                                header: "Status",
                                footer: "<div class='webix_el_button'><a href='/content/plugins/click-collect-plugin/templates/print-all-orders.php?location=" + getUrlParameter('location') + "&date=" + i + "&status=to-be-made' class='print_all_awaiting'>Print New</a></div>",
                                fillspace: true,
                                editor: 'richselect',
                                options: order_status,
                                cssFormat:markNew
                            },
                            {
                                id: "shop_order_number",
                                css: {"font-weight": "bold", 'text-align': 'center'},
                                header: "Shop Order No.",
                                width: 150,
                                editor: 'text'
                            },
                            {
                                id: "action", header: "Action",
                                fillspace: true,
                                template: function (obj) {
                                    return "<div class='webix_el_button'><button class='add_notes'> Add Notes</button></div><div class='webix_el_button'><button class='view_order'> View Order</button></div>";
                                },
                                width: 250
                            }
                        ],
                        on: {
                            "onAfterEditStop": function (state, editor, ignoreUpdate) {
                                if (state.value !== state.old) {
                                    //// UPDATE SHOP ORDER NUMBER /////
                                    if (editor.column === 'shop_order_number') {
                                        webix.ajax("/wp-json/click-collect/v1/set-shop-order-number/" + state.value + '/' + editor.row, function (text, data, xhr) {
                                            webix.message({type: "message-style", text: "Shop number saved"});
                                        });
                                    }
                                    //// UPDATE SHOP ORDER STATUS /////
                                    if (editor.column === 'status') {
                                        webix.ajax("/wp-json/click-collect/v1/update-order-status/" + state.value + '/' + editor.row, function (text, data, xhr) {
                                            console.log(state.value);
                                            if (text === '"Order not Updated, please check you have input the shop number and final price"') {
                                                webix.message({type: "message-style", text: text});
                                                setTimeout(window.location.reload.bind(window.location), 2000);
                                            } else {
                                                webix.message({type: "message-style", text: text});
                                            }
                                            $$("status").refresh();
                                        });
                                    }
                                }
                            },
                        },

                        autoheight: true,
                        data: val.orders,
                        conditionStyle: [
                            {name: 'red', css: "cancelled"}
                        ],
                        onClick: {
                            "add_notes": function (e, id, trg) {
                                webix.message({type: "message-style", text: "Loading notes for order: " + id});
                                webix.ajax("/wp-json/click-collect/v1/get-notes/" + id, function (text, data, xhr) {
                                    windowInfo = data.json();
                                    if (windowInfo) {
                                        webix.ui({
                                            view: "window",
                                            id: "notes_window",
                                            head: {
                                                cols: [{template: '', borderless: true}, {}, {
                                                    view: "icon",
                                                    icon: "wxi-close-circle",
                                                    click: ("$$('notes_window').destructor();")
                                                }]
                                            },
                                            autoHeight: true,
                                            modal: true,
                                            position: "center",
                                            width: 1200,
                                            height: 500,
                                            borderless: true,
                                            body: {
                                                rows: [
                                                    {
                                                        id: "notes_table",
                                                        view: "datatable",
                                                        scroll: 'y',
                                                        css: "note-grid",
                                                        fixedRowHeight: false,
                                                        rowLineHeight: 25,
                                                        columns: [
                                                            {id: 'note_content', header: 'Note', fillspace: true},
                                                        ],
                                                        data: windowInfo,
                                                        on: {
                                                            "onresize": function () {
                                                                this.adjustRowHeight();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        view: "form",
                                                        id: "notes_form",
                                                        height: 200,
                                                        elements: [
                                                            {
                                                                view: "textarea", label: "Add Note", name: "note",
                                                                labelWidth: 250,
                                                                labelAlign: 'right',
                                                            },
                                                            {
                                                                view: "button",
                                                                value: "Save",
                                                                label: "Save",
                                                                labelAlign: "center",
                                                                align: "left",
                                                                click: submitNote
                                                            },
                                                        ]
                                                    }
                                                ]
                                            }
                                        });
                                        $$("notes_window").show();
                                        $$("notes_form").setValues(
                                            {order_id: id}
                                        );
                                    }
                                });
                            },
                            "view_order": function (e, id, trg) {
                                var item = this.getItem(id);
                                webix.message({type: "message-style", text: "Loading order: " + id});
                                webix.ajax("/wp-json/click-collect/v1/get-orders/" + id, function (text, data, xhr) {
                                    windowInfo = data.json();
                                    console.log(windowInfo);
                                    if (windowInfo) {
                                        webix.ui({
                                            view: "window",
                                            id: "order_window",
                                            padding: 50,
                                            head: {
                                                cols: [{template: ''}, {}, {
                                                    view: "icon",
                                                    icon: "wxi-close-circle",
                                                    click: ("location.reload();")
                                                }]
                                            },
                                            position: "center",
                                            autoheight: 650,
                                            scroll: "y",
                                            move: true,
                                            modal: true,
                                            body: {
                                                width:1000,
                                                rows: [
                                                    {
                                                        height: 250,
                                                        cols: [
                                                            {width: 50},
                                                            {
                                                                width: 600,
                                                                css: "print-smaller",
                                                                rows: [
                                                                    {
                                                                        template: '<strong>Date for Collection: </strong>' + windowInfo.pickup_date,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Client Name: </strong>' + item.client_name,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Contact Number: </strong>' + item.contact_number,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Web order no. ' + item.id + '</strong>',
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {},
                                                                    {},
                                                                    {
                                                                        cols: [
                                                                            {
                                                                                template: "<strong>Estimated Price: </strong>£" + windowInfo.price,
                                                                                borderless: true,
                                                                                autoheight: true,
                                                                                width: 250
                                                                            },
                                                                            {
                                                                                view: "text",
                                                                                id: 'final_price',
                                                                                label: "<strong>Actual Price: £</strong>",
                                                                                placeholder: "Input Final Price",
                                                                                borderless: true,
                                                                                width: 300,
                                                                                labelWidth: 125,
                                                                                labelAlign: 'right',
                                                                                value: item.final_price
                                                                            },
                                                                        ]
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                width: 300,
                                                                rows: [
                                                                    {
                                                                        css: 'border_box',
                                                                        view: "text",
                                                                        id: "shop_number",
                                                                        value: item.shop_order_number,
                                                                        label: 'Shop Order No.',
                                                                        labelWidth: 175,
                                                                    },
                                                                    {height: 25},
                                                                    {
                                                                        css: 'border_box',
                                                                        view: "select",
                                                                        id: "status_select",
                                                                        label: "Status",
                                                                        options: order_status,
                                                                        value: item.status,
                                                                        labelWidth: 175,
                                                                    },
                                                                    {},
                                                                    {},
                                                                    {},
                                                                    {},
                                                                    {
                                                                        borderless: true,
                                                                        autoheight: true,
                                                                        template: function (obj) {
                                                                            return "<div class='webix_el_button'><button class='add_notes'> Add Notes</button></div><div class='webix_el_button'><a class='print_order' href='/content/plugins/click-collect-plugin/templates/print-single-order.php?location=" + getUrlParameter('location') + "&order="+item.id+"&date=" + i + "'>Print Order</a></div><div class='webix_el_button'><button class='print_label'> Print Label</button></div>";
                                                                        },
                                                                        onClick: {
                                                                            "print_label": function (e, id, trg) {
                                                                                var orderNo = $$('shop_number').getValue();
                                                                                console.log(orderNo);
                                                                                $$('print_order_number').setValue(orderNo);
                                                                                webix.print($$("label_window"), {
                                                                                    mode: "landscape",
                                                                                    fit: "data",
                                                                                    paper: 'a4'
                                                                                });
                                                                            },
                                                                            "add_notes": function (e, id, trg) {
                                                                                webix.message({
                                                                                    type: "message-style",
                                                                                    text: "Loading notes for order: " + item.id
                                                                                });
                                                                                webix.ajax("/wp-json/click-collect/v1/get-notes/" + item.id, function (text, data, xhr) {
                                                                                    windowInfo = data.json();
                                                                                    if (windowInfo) {
                                                                                        webix.ui({
                                                                                            view: "window",
                                                                                            id: "notes_window",
                                                                                            head: {
                                                                                                cols: [{
                                                                                                    template: '',
                                                                                                    borderless: true
                                                                                                }, {}, {
                                                                                                    view: "icon",
                                                                                                    icon: "wxi-close-circle",
                                                                                                    click: ("$$('notes_window').destructor();")
                                                                                                }]
                                                                                            },
                                                                                            autoHeight: true,
                                                                                            modal: true,
                                                                                            position: "center",
                                                                                            width: 1200,
                                                                                            height:500,
                                                                                            borderless: true,
                                                                                            body: {
                                                                                                rows: [
                                                                                                    {
                                                                                                        id: "notes_table",
                                                                                                        view: "datatable",
                                                                                                        scroll: 'y',
                                                                                                        css: "note-grid",
                                                                                                        fixedRowHeight: false,
                                                                                                        rowLineHeight: 25,
                                                                                                        columns: [
                                                                                                            {
                                                                                                                id: 'note_content',
                                                                                                                header: 'Note',
                                                                                                                fillspace: true
                                                                                                            },
                                                                                                        ],
                                                                                                        data: windowInfo,
                                                                                                        on: {
                                                                                                            "onresize": function () {
                                                                                                                this.adjustRowHeight();
                                                                                                            }
                                                                                                        }
                                                                                                    },
                                                                                                    {
                                                                                                        view: "form",
                                                                                                        id: "notes_form",
                                                                                                        height: 200,
                                                                                                        elements: [
                                                                                                            {
                                                                                                                view: "textarea",
                                                                                                                label: "Add Note",
                                                                                                                name: "note",
                                                                                                                labelWidth: 250,
                                                                                                                labelAlign: 'right',
                                                                                                            },
                                                                                                            {
                                                                                                                view: "button",
                                                                                                                value: "Save",
                                                                                                                label: "Save",
                                                                                                                labelAlign: "center",
                                                                                                                align: "left",
                                                                                                                click: submitNote
                                                                                                            },
                                                                                                        ]
                                                                                                    }
                                                                                                ]
                                                                                            }
                                                                                        });
                                                                                        $$("notes_window").show();
                                                                                        $$("notes_form").setValues(
                                                                                            {order_id: item.id}
                                                                                        );
                                                                                    }
                                                                                });
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        css: 'hidden_window',
                                                                        id: 'label_window',
                                                                        width:3000,
                                                                        height: 1,
                                                                        rows: [
                                                                            {
                                                                                css: 'border_box',
                                                                                view: "text",
                                                                                id: "print_order_number",
                                                                                value: '',
                                                                                label: 'Shop Order No.',
                                                                                labelWidth: 175,
                                                                            },
                                                                            {
                                                                                template: '<p><strong>Phone Number: </strong>' + item.contact_number+'</p>',
                                                                                borderless: true,
                                                                                height: 140,
                                                                                width:3000

                                                                            },
                                                                            {
                                                                                template: '<p><strong>Client Name: </strong>' + item.client_name+'</p>',
                                                                                borderless: true,
                                                                                height: 140,
                                                                                width:3000
                                                                            },
                                                                            {
                                                                                template: '<p><strong>Collection Date: </strong>' + val.date+'</p>',
                                                                                borderless: true,
                                                                                height: 140,
                                                                                width:3000
                                                                            },

                                                                        ]

                                                                    },
                                                                ]
                                                            },
                                                            {width: 50},
                                                        ]
                                                    },
                                                    {height: 45, borderless: true},
                                                    {
                                                        cols: [
                                                            {width: 50},
                                                            {
                                                                template: '<h2>Items in order:</h2>',
                                                                padding: 50,
                                                                autoheight: true,
                                                                borderless: true

                                                            }
                                                        ]
                                                    },
                                                    {
                                                        view: "datatable",
                                                        id: "window_order_table",
                                                        rowHeight: 75,
                                                        height: 300,
                                                        scroll: "y",
                                                        columns: [
                                                            {width: 50},
                                                            {
                                                                id: 'product_thumbnail',
                                                                header: '',
                                                                template: function (obj) {
                                                                    return "<img style='display:block; ' src='" + obj.product_thumbnail + "'/>";
                                                                },
                                                                autowidth:true,
                                                                css:'hidden-column'
                                                            },
                                                            {
                                                                id: 'product_title',
                                                                header: 'Product Title',
                                                                css: 'print-column',
                                                                fillspace:true
                                                            },
                                                            {id: 'weight', header: 'Weight (g)', css: 'print-column'},
                                                            {
                                                                id: 'unit_label',
                                                                header: 'Unit Label',
                                                                fillspace:true,
                                                                css: 'print-column'
                                                            },
                                                            {
                                                                id: 'unit',
                                                                header: 'Units',
                                                                css: 'print-column'
                                                            },
                                                            {id: 'size', header: 'by Pack Size', fillspace:true, css: 'print-column'},
                                                            {id: 'qty', header: 'Qty', css: 'print-column'},
                                                            {id: 'sku', header: 'SKU', css: 'print-column'},
                                                            {width: 50}
                                                        ],
                                                        fixedRowHeight:false,
                                                        rowLineHeight:25,
                                                        data: windowInfo.orders
                                                    }
                                                ]
                                            },

                                        });
                                        $$("order_window").show();
                                        $$("shop_number").attachEvent("onBlur", function () {
                                            webix.ajax("/wp-json/click-collect/v1/set-shop-order-number/" + $$('shop_number').getValue() + '/' + id, function (text, data, xhr) {
                                                var record = $$("box" + i);
                                                var item = record.getItem(id);
                                                item['shop_order_number'] = $$('shop_number').getValue();
                                                record.updateItem(id, item);
                                                webix.message({type: "message-style", text: "Shop number saved"});

                                            });
                                        });
                                        $$("final_price").attachEvent("onBlur", function () {
                                            console.log($$('final_price').getValue());
                                            formValues = $$('final_price').getValue();
                                            console.log($$('final_price').getValue());
                                            if ($$('final_price').getValue() != '') {
                                                webix.ajax().post("/wp-json/click-collect/v1/set-final-price/", {
                                                    action: "finalPrice",
                                                    formValues,
                                                    id
                                                }, function (text, data, xhr) {
                                                    webix.message({type: "message-style", text: "Final Price saved"});

                                                });
                                            }
                                        });

                                        $$("status_select").attachEvent("onChange", function () {
                                            webix.ajax("/wp-json/click-collect/v1/update-order-status/" + $$('status_select').getValue() + '/' + id, function (text, data, xhr) {
                                                if (text === '"Order not Updated, please check you have input the shop number and final price"') {
                                                    webix.message({type: "message-style", text: text});
                                                } else {
                                                    webix.message({type: "message-style", text: text});
                                                }
                                            });
                                        });
                                    }
                                });

                            }
                        },
                    }
                },
                {height: 35}
            ]
        };
        webix.ready(function () {
            webix.ui(grid);
        });

    });


    $('.new').html(newOrderCount);
    $('.ready').html(readyOrderCount);
    $('.to-make').html(toMakeCount);
})();

