<style>
    h2 {
        padding: 25px;
    }

    .order-window {
        page-break-after: always;
        border-bottom: 1px solid #000;
        width: 100%;
        display: block;
        padding: 25px 25px 25px 25px;
    }

    .order-window .header {
        display: block;
        width: 100%;
        margin-bottom: 35px;
    }

    .order-window div {
        width: auto;
        display: inline-block;
        padding-right: 15px;
    }

    .ordered-items {
        display: block !important;
        padding: 15px 0;
    }

    .ordered-items div {
        display: block;
    }
</style>

<?php
ini_set('error_reporting', E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);

use B2\OrderController;

require "../vendor/autoload.php";
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-config.php');

$orderNo = $_GET['order'];
$location = $_GET['location'];

$order = B2\OrderController::getSingleOrderForPrint($orderNo);

?>
<?php foreach ($order as $singleOrder) { ?>
<div class="order-window">
    <div class="header">
        <div><strong>Order Id:</strong> <?= $singleOrder['order']['id'] ?></div>
        <div><strong>Customer:</strong> <?= $singleOrder['order']['client_name']; ?></div>
        <div><strong>Contact Number:</strong> <?= $singleOrder['order']['contact_number']; ?></div>
        <div><strong>Shop Order Number:</strong> <?= $singleOrder['order']['shop_order_number']; ?></div>
        <div><strong>Final Price:</strong> <?= $singleOrder['order']['final_price']; ?></div>
    </div>
    <?php foreach ($singleOrder['orderItems'] as $orderItem) { ?>
        <div class="ordered-items">
            <div><strong>Product Title:</strong> <?= $orderItem['product_title']; ?></div>
            <div><strong>Product Weight:</strong> <?= $orderItem['weight']; ?></div>
            <div><strong>Unit Label:</strong> <?= $orderItem['unit_label']; ?></div>
            <div><strong>Units:</strong> <?= $orderItem['unit']; ?></div>
            <div><strong>Size: <?= $orderItem['size']; ?></strong></div>
            <div><strong>Qty:</strong> <?= $orderItem['qty']; ?></div>
            <div><strong>SKU:</strong> <?= $orderItem['sku']; ?></div>
        </div>
    <?php } ?>
</div>
<?php } ?>
<script>
    window.print();
    window.onafterprint = function() {
        location.replace('/click-collect-dashboard?location=<?= $location; ?>');
    };
</script>

<?php exit; ?>
