<style>
    h2 {
        padding: 25px;
    }

    .order-window {
        page-break-after: always;
        border-bottom: 1px solid #000;
        width: 100%;
        display: block;
        padding: 25px 25px 25px 25px;
    }

    .order-window .header {
        display: block;
        width: 100%;
        margin-bottom: 35px;
    }

    .order-window div {
        width: auto;
        display: inline-block;
        padding-right: 15px;
    }

    .ordered-items {
        display: block !important;
        padding: 15px 0;
    }

    .ordered-items div {
        display: block;
    }
</style>

<?php
ini_set('error_reporting', E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);

require "../vendor/autoload.php";
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-config.php');

$date = $_GET['date'];
$location = $_GET['location'];
$status = $_GET['status'];

$orders = B2\OrderController::getAllOrdersForPrint($location, $date, $status);
?>

<?php foreach ($orders as $order) { ?>
    <div class="order-window">
        <h2>Orders for: <?= date('d-m-Y', $date); ?></h2>
        <div class="header">
            <div><strong>Order Id:</strong> <?= $order['order']['id'] ?></div>
            <div><strong>Order Date:</strong> <?= date_format($order['order']['order_date'], 'd-m-Y') ?></div>
            <div><strong>Customer:</strong> <?= $order['order']['client_name']; ?></div>
            <div><strong>Contact Number:</strong> <?= $order['order']['contact_number']; ?></div>
            <div><strong>Shop Order Number:</strong> <?= $order['order']['shop_order_number']; ?></div>
            <div><strong>Final Price:</strong> <?= $order['order']['final_price']; ?></div>
        </div>
        <?php foreach ($order['orderItems'] as $orderItem) { ?>
            <div class="ordered-items">
                <div><strong>Product Title:</strong> <?= $orderItem['product_title']; ?></div>
                <div><strong>Product Weight:</strong> <?= $orderItem['weight']; ?></div>
                <div><strong>Unit Label:</strong> <?= $orderItem['unit_label']; ?></div>
                <div><strong>Units:</strong> <?= $orderItem['unit']; ?></div>
                <div><strong>Size: <?= $orderItem['size']; ?></strong></div>
                <div><strong>Qty:</strong> <?= $orderItem['qty']; ?></div>
            </div>
        <?php } ?>
    </div>
<?php } ?>

<script>
    window.print();
    window.onafterprint = function() {
        location.replace('/click-collect-dashboard?location=<?= $location; ?>' );
    };
</script>

<?php exit; ?>
