/** TODO update refresh to only refresh data( not window) **/
let idleTime = 0;
function timerIncrement() {
    idleTime = idleTime + 1;
    console.log(idleTime);
    if (idleTime > 1) { // 1 minutes
        window.location.reload();
    }
}
(function () {
    setInterval (timerIncrement, 60000);
    $(this).mousemove(function (e) {
        idleTime = 0;
    });
    $(this).keypress(function (e) {
        idleTime = 0;
    });
})();

function submitNote() {
    if (this.getParentView().validate()) {
        var formValues = $$("notes_form").getValues();
        console.log(formValues);

        webix.ajax().post("/wp-json/click-collect/v1/add-note/", {
            action: "note",
            formValues
        }, function (text, data, xhr) {
            if (data.json() === 'success') {
                webix.message({type: "message-style", text: "Comment added"});
                var note = {note_content: formValues.note};
                $$("notes_table").add(note);
            } else {
                webix.message({type: "message-style", text: "Sorry something went wrong, please try again"});
            }
        });
    }
}


(function () {

    let newOrderCount = 0;
    let readyOrderCount = 0;
    let toMakeCount = 0;
    let collectedCount = 0;

    jQuery.each(data, function (i, val) {

        jQuery.each(val.orders, function (i, val) {
            if (val.status === '1') {
                newOrderCount++;
            } else if (val.status === '5') {
                readyOrderCount++;
            }else if (val.status === '6') {
                collectedCount++;
            } else if(val.status !== '5' || val.status !== '6') {
                toMakeCount++;
            }
        });

        console.log(collectedCount);
        
        $('#boxcontainer').append("<div id='box" + i + "'></div>");


        var order_status = [
            {id: 1, value: "New Order"},
            {id: 2, value: "Awaiting Processing"},
            {id: 3, value: "Started"},
            {id: 4, value: "Being Collated"},
            {id: 5, value: "Ready for collection"},
            {id: 6, value: "Collected"},
        ];
        var grid = {
            container: "box" + i,
            borderless: true,
            multi: true,
            rows: [
                {
                    header: '<div class="title">Order Collection Date: <span>' + val.date + '</span></div><div class="display"><strong>Display:</strong> <a>All: <span class="order-count">' + val.orders.length + '</span></a>| <a>Needing made up: </span>0</span></a></div>',
                    headerHeight: 100,
                    collapsed: false,
                    body: {
                        view: "datatable",
                        editable: true,
                        footer: true,
                        responsive:true,
                        id: "box" + i,
                        position: "center",
                        rowHeight: 65,
                        columns: [
                            {width:25},
                            {
                                id: "id",
                                header: "Web order No.",
                                css: {'font-weight':'bold'},
                                width: 150
                            },
                            {id: "client_name", header: "Client Name", width: 250},
                            {id: "contact_number", header: "Contact Number", width: 150},
                            {
                                id: "status",
                                css:"select_column",
                                header: "Status",
                                footer: "<div class='webix_el_button'><button class='print_all'>Print all orders</button></div>",
                                width: 250,
                                editor: 'richselect',
                                options: order_status
                            },
                            {
                                id: "shop_order_number",
                                css:{"font-weight":"bold", 'text-align':'center'},
                                header: "Shop Order No.",
                                width: 150,
                                editor: 'text'
                            },
                            {
                                id: "action", header: "Action",
                                fillspace: true,
                                template: function (obj) {
                                    return "<div class='webix_el_button'><button class='add_notes'> Add Notes</button></div><div class='webix_el_button'><button class='view_order'> View</button></div>";
                                },
                                width: 250
                            }
                        ],
                        on: {
                            "onAfterEditStop": function (state, editor, ignoreUpdate) {
                                if (state.value !== state.old) {
                                    //// UPDATE SHOP ORDER NUMBER /////
                                    if (editor.column === 'shop_order_number') {
                                        webix.ajax("/wp-json/click-collect/v1/set-shop-order-number/" + state.value + '/' + editor.row, function (text, data, xhr) {
                                            webix.message({type: "message-style", text: "Shop number saved"});
                                        });
                                    }
                                    //// UPDATE SHOP ORDER STATUS /////
                                    if (editor.column === 'status') {
                                        webix.ajax("/wp-json/click-collect/v1/update-order-status/" + state.value + '/' + editor.row, function (text, data, xhr) {
                                            webix.message({type: "message-style", text: text});
                                        });
                                    }
                                }
                            }
                        },
                        autoheight: true,
                        data: val.orders,
                        onClick: {
                            "add_notes": function (e, id, trg) {
                                webix.message({type: "message-style", text: "Loading notes for order: " + id});
                                webix.ajax("/wp-json/click-collect/v1/get-notes/" + id, function (text, data, xhr) {
                                    windowInfo = data.json();
                                    if (windowInfo) {
                                        webix.ui({
                                            view: "window",
                                            id: "notes_window",
                                            head: {
                                                cols: [{template: '', borderless: true}, {}, {
                                                    view: "icon",
                                                    icon: "wxi-close-circle",
                                                    click: ("$$('notes_window').destructor();")
                                                }]
                                            },
                                            autoHeight: true,
                                            modal: true,
                                            position: "center",
                                            width: 1200,
                                            height: 800,
                                            borderless: true,
                                            body: {
                                                rows: [
                                                    {
                                                        id: "notes_table",
                                                        view: "datatable",
                                                        scroll: 'y',
                                                        css: "note-grid",
                                                        fixedRowHeight: false,
                                                        rowLineHeight: 25,
                                                        columns: [
                                                            {id: 'note_content', header: 'Note', fillspace: true},
                                                        ],
                                                        data: windowInfo,
                                                        on: {
                                                            "onresize": function () {
                                                                this.adjustRowHeight();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        view: "form",
                                                        id: "notes_form",
                                                        height: 200,
                                                        elements: [
                                                            {
                                                                view: "textarea", label: "Add Note", name: "note",
                                                                labelWidth: 250,
                                                                labelAlign: 'right',
                                                            },
                                                            {
                                                                view: "button",
                                                                value: "Save",
                                                                label: "Save",
                                                                labelAlign: "center",
                                                                align: "left",
                                                                click: submitNote
                                                            },
                                                        ]
                                                    }
                                                ]
                                            }
                                        });
                                        $$("notes_window").show();
                                        $$("notes_form").setValues(
                                            {order_id: id}
                                        );
                                    }
                                });
                            },
                            "view_order": function (e, id, trg) {
                                var item = this.getItem(id);
                                webix.message({type: "message-style", text: "Loading order: " + id});
                                webix.ajax("/wp-json/click-collect/v1/get-orders/" + id, function (text, data, xhr) {
                                    windowInfo = data.json();
                                    if (windowInfo) {
                                        webix.ui({
                                            view: "window",
                                            id: "order_window",
                                            padding:50,
                                            head: {
                                                cols: [{template: ''}, {}, {
                                                    view: "icon",
                                                    icon: "wxi-close-circle",
                                                    click: ("$$('order_window').destructor();")
                                                }]
                                            },
                                            autowidth: true,
                                            position: "center",
                                            autoheight: true,
                                            move: true,
                                            modal:true,
                                            body: {
                                                rows: [
                                                    {
                                                        height: 250,
                                                        cols: [
                                                            {width:50},
                                                            {
                                                                width: 500,
                                                                css:"print-smaller",
                                                                rows: [
                                                                    {
                                                                        template: '<strong>Date for Collection: </strong>' + windowInfo.pickup_date,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Client Name: </strong>' + item.client_name,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Contact Number: </strong>' + item.contact_number,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Web order no. ' + item.id + '</strong>',
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {},
                                                                    {},
                                                                    {
                                                                        cols: [
                                                                            {
                                                                                template: "<strong>Estimated Price: </strong>£" + windowInfo.price,
                                                                                borderless: true,
                                                                                autoheight: true,
                                                                                width:250
                                                                            },
                                                                            {
                                                                                view: "text",
                                                                                id: 'final_price',
                                                                                label: "<strong>Actual Price: £</strong>",
                                                                                placeholder: "Input Final Price",
                                                                                borderless: true,
                                                                                width:220,
                                                                                labelWidth:125,
                                                                                labelAlign: 'right',
                                                                                value: item.final_price
                                                                            },
                                                                        ]
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                width:350,
                                                                rows: [
                                                                    {
                                                                        css:'border_box',
                                                                        view: "text",
                                                                        id: "shop_number",
                                                                        value: item.shop_order_number,
                                                                        label: 'Shop Order No.',
                                                                        labelWidth:175,
                                                                    },
                                                                    {height:25},
                                                                    {
                                                                        css:'border_box',
                                                                        view: "select",
                                                                        id: "status_select",
                                                                        label: "Status",
                                                                        options: order_status,
                                                                        value: item.status,
                                                                        labelWidth:175,
                                                                    },
                                                                    {},
                                                                    {},
                                                                    {},
                                                                    {},
                                                                    {
                                                                        borderless: true,
                                                                        autoheight: true,
                                                                        template: function (obj) {
                                                                            return "<div class='webix_el_button'><button class='add_notes'> Add Note</button></div><div class='webix_el_button'><button class='print_order'> Print Order</button></div>";
                                                                        },
                                                                        onClick: {
                                                                            "print_order": function (e, id, trg) {

                                                                                webix.print($$("order_window"), {
                                                                                    mode: "portrait",
                                                                                    fit: "page"
                                                                                });

                                                                            },
                                                                            "add_notes": function (e, id, trg) {
                                                                                webix.message({
                                                                                    type: "message-style",
                                                                                    text: "Loading notes for order: " + item.id
                                                                                });
                                                                                webix.ajax("/wp-json/click-collect/v1/get-notes/" + item.id, function (text, data, xhr) {
                                                                                    windowInfo = data.json();
                                                                                    if (windowInfo) {
                                                                                        webix.ui({
                                                                                            view: "window",
                                                                                            id: "notes_window",
                                                                                            head: {
                                                                                                cols: [{
                                                                                                    template: '',
                                                                                                    borderless: true
                                                                                                }, {}, {
                                                                                                    view: "icon",
                                                                                                    icon: "wxi-close-circle",
                                                                                                    click: ("$$('notes_window').destructor();")
                                                                                                }]
                                                                                            },
                                                                                            autoHeight: true,
                                                                                            modal: true,
                                                                                            position: "center",
                                                                                            width: 1200,
                                                                                            height: 800,
                                                                                            borderless: true,
                                                                                            body: {
                                                                                                rows: [
                                                                                                    {
                                                                                                        id: "notes_table",
                                                                                                        view: "datatable",
                                                                                                        scroll: 'y',
                                                                                                        css: "note-grid",
                                                                                                        fixedRowHeight: false,
                                                                                                        rowLineHeight: 25,
                                                                                                        columns: [
                                                                                                            {
                                                                                                                id: 'note_content',
                                                                                                                header: 'Note',
                                                                                                                fillspace: true
                                                                                                            },
                                                                                                        ],
                                                                                                        data: windowInfo,
                                                                                                        on: {
                                                                                                            "onresize": function () {
                                                                                                                this.adjustRowHeight();
                                                                                                            }
                                                                                                        }
                                                                                                    },
                                                                                                    {
                                                                                                        view: "form",
                                                                                                        id: "notes_form",
                                                                                                        height: 200,
                                                                                                        elements: [
                                                                                                            {
                                                                                                                view: "textarea",
                                                                                                                label: "Add Note",
                                                                                                                name: "note",
                                                                                                                labelWidth: 250,
                                                                                                                labelAlign: 'right',
                                                                                                            },
                                                                                                            {
                                                                                                                view: "button",
                                                                                                                value: "Save",
                                                                                                                label: "Save",
                                                                                                                labelAlign: "center",
                                                                                                                align: "left",
                                                                                                                click: submitNote
                                                                                                            },
                                                                                                        ]
                                                                                                    }
                                                                                                ]
                                                                                            }
                                                                                        });
                                                                                        $$("notes_window").show();
                                                                                        $$("notes_form").setValues(
                                                                                            {order_id: item.id}
                                                                                        );
                                                                                    }
                                                                                });
                                                                            }
                                                                        }
                                                                    },
                                                                ]
                                                            },
                                                            {width:50},
                                                        ]
                                                    },
                                                    {height: 45, borderless: true},
                                                    {
                                                        cols: [
                                                            {width:50},
                                                            {
                                                                template: '<h2>Items in order:</h2>',
                                                                padding:50,
                                                                autoheight: true,
                                                                borderless: true

                                                            }
                                                        ]
                                                    },
                                                    {
                                                        view: "datatable",
                                                        autoheight: true,
                                                        id:"window_order_table",
                                                        rowHeight: 65,
                                                        columns: [
                                                            {width:50},
                                                            {id: 'product_thumbnail', header: '', template:function(obj){
                                                                    return "<img style='display:block; ' src='"+obj.product_thumbnail+"'/>";
                                                                }
                                                            },
                                                            {
                                                                id: 'product_title',
                                                                header: 'Product Title',
                                                                css:'print-column',
                                                                width:200
                                                            },
                                                            {id: 'weight', header: 'Weight (g)', css:'print-column'},
                                                            {id: 'people', header: 'No. of People',css:'print-column'},
                                                            {id: 'size', header: 'by Pack Size', css:'print-column'},
                                                            {id: 'qty', header: 'Quantity', css:'print-column'},
                                                            {width:50}
                                                        ],
                                                        data: windowInfo.orders
                                                    }
                                                ]
                                            },

                                        });
                                        $$("order_window").show();
                                        $$("shop_number").attachEvent("onBlur", function () {
                                            webix.ajax("/wp-json/click-collect/v1/set-shop-order-number/" + $$('shop_number').getValue() + '/' + id, function (text, data, xhr) {
                                                var record = $$("box" + i);
                                                var item = record.getItem(id);
                                                item['shop_order_number'] = $$('shop_number').getValue();
                                                record.updateItem(id, item);
                                                webix.message({type: "message-style", text: "Shop number saved"});

                                            });
                                        });
                                        $$("final_price").attachEvent("onBlur", function () {
                                            webix.ajax("/wp-json/click-collect/v1/set-final-price/" + $$('final_price').getValue() + '/' + id, function (text, data, xhr) {
                                                webix.message({type: "message-style", text: "Final Price saved"});

                                            });
                                        });

                                        $$("status_select").attachEvent("onChange", function () {
                                            webix.ajax("/wp-json/click-collect/v1/update-order-status/" + $$('status_select').getValue() + '/' + id, function (text, data, xhr) {
                                                webix.message({type: "message-style", text: "Status Updated"});
                                            });
                                        });
                                    }
                                });

                            }
                        },

                    }
                },
                {height: 35}
            ]
        };

        webix.ready(function () {
            webix.ui(grid);
        });
        
        
    });

    $('.new').html(newOrderCount);
    $('.ready').html(readyOrderCount);
    $('.to-make').html(toMakeCount);
})();

