<?php

namespace B2\Order;

class OrderItem
{
    private $orderItemData;
    private $itemKey;
    private $orderId;

    public function __construct($orderItemData, $itemKey, $orderId)
    {
        $this->orderItemData = $orderItemData;
        $this->itemKey = $itemKey;
        $this->orderId = $orderId;
    }

    public function getProduct()
    {
        return $this->orderItemData->get_product();
    }

    public function getProductId()
    {
        return $this->orderItemData->get_product_id();
    }

    public function getOrderName()
    {
        return $this->orderItemData->get_name();
    }

    public function getQuantity()
    {
        return $this->orderItemData->get_quantity();
    }

    public function getTotal()
    {
        return $this->orderItemData->get_total();
    }

    public function getProductMeta()
    {
        return get_post_meta($this->getProductId());
    }

    public function getWeightForOne()
    {
        return $this->getProductMeta()['weight_to_feed_one_person'][0];
    }

    public function getOrderItemWeight()
    {
        return wc_get_order_item_meta($this->itemKey, 'Weight (g)');
    }

    public function getPackSize()
    {
        $packSize = new OrderPackSize($this->getProduct());
        return ($packSize->getPackSize() ? $packSize->getPackSize() : '');
    }

    public function getNoOfPeople()
    {
        return ($this->getOrderItemWeight() ? ($this->getOrderItemWeight() / $this->getWeightForOne()) : '');
    }

    public function newOrderItemData()
    {

        $newItemArray = [
            'product_title' => $this->getOrderName(),
            'weight' => $this->getOrderItemWeight(),
            'people' => floor($this->getNoOfPeople()),
            'size' => $this->getPackSize(),
            'qty' => $this->getQuantity()
        ];

        return $newItemArray;
    }

}